/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.xmlwriter.XMLWriter;

public final class XMLStartElement
extends TokenBase
implements XMLToken,
StartElementToken {
    private final String uri;
    private final String name;
    private final int hashCode;

    public XMLStartElement(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Element must have a name.");
        }
        this.uri = "";
        this.name = name;
        this.hashCode = this.toHashCode("", name);
    }

    public XMLStartElement(String uri, String localName) throws NullPointerException {
        if (uri == null) {
            throw new NullPointerException("The URI cannot be null, use \"\".");
        }
        if (localName == null) {
            throw new NullPointerException("Element must have a name.");
        }
        this.uri = uri;
        this.name = localName;
        this.hashCode = this.toHashCode(uri, localName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespaceURI() {
        return this.uri;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(XMLToken token) {
        if (token == this) {
            return true;
        }
        if (!(token instanceof StartElementToken)) {
            return false;
        }
        if (this.hashCode != token.hashCode()) {
            return false;
        }
        StartElementToken other = (StartElementToken)token;
        return this.name.equals(other.getName()) && this.uri.equals(other.getNamespaceURI());
    }

    public String toString() {
        if (this.uri.isEmpty()) {
            return "<" + this.name + '>';
        }
        return "<{" + this.uri + "}:" + this.name + '>';
    }

    @Override
    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement(this.uri, this.name, false);
    }

    @Override
    public void toXML(XMLStreamWriter xml) throws XMLStreamException {
        if (this.uri.isEmpty()) {
            xml.writeStartElement(this.name);
        } else {
            xml.writeStartElement(this.uri, this.name);
        }
    }

    @Override
    public String getValue() {
        return null;
    }

    private int toHashCode(String uri, String name) {
        assert (uri != null);
        assert (name != null);
        int hash = 107;
        hash = hash * 13 + uri.hashCode();
        hash = hash * 13 + name.hashCode();
        return hash;
    }
}

