/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.io.IOException;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.xmlwriter.XMLWriter;

public final class XMLProcessingInstruction
extends TokenBase
implements XMLToken {
    private final String target;
    private final String data;
    private final int hashCode;

    public XMLProcessingInstruction(String target, String data) throws NullPointerException {
        this.target = Objects.requireNonNull(target, "Processing instruction target must not be null, use \"\" instead");
        this.data = Objects.requireNonNull(data, "Processing instruction data must not be null, use \"\" instead");
        this.hashCode = XMLProcessingInstruction.toHashCode(target, data);
    }

    @Override
    public String getName() {
        return this.target;
    }

    @Override
    public String getValue() {
        return this.data;
    }

    public String getTarget() {
        return this.target;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(XMLToken token) {
        if (token == null) {
            return false;
        }
        if (token.getClass() != this.getClass()) {
            return false;
        }
        XMLProcessingInstruction pi = (XMLProcessingInstruction)token;
        return pi.target.equals(this.target) && pi.data.equals(this.data);
    }

    public String toString() {
        return "pi: " + this.target + ": " + this.data;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.writePI(this.target, this.data);
    }

    @Override
    public void toXML(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeProcessingInstruction(this.target, this.data);
    }

    @Override
    public XMLTokenType getType() {
        return XMLTokenType.PROCESSING_INSTRUCTION;
    }

    private static int toHashCode(String target, String data) {
        int hash = 7;
        hash = hash * 103 + target.hashCode();
        hash = hash * 103 + data.hashCode();
        return hash;
    }
}

