/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.diffx.token.impl.XMLStartElement;

public final class XMLEndElement
extends TokenBase
implements EndElementToken {
    private final StartElementToken open;

    public XMLEndElement(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Element must have a name.");
        }
        this.open = new XMLStartElement(name);
    }

    public XMLEndElement(String uri, String localName) throws NullPointerException {
        if (uri == null) {
            throw new NullPointerException("The URI cannot be null, use \"\".");
        }
        if (localName == null) {
            throw new NullPointerException("Element must have a name.");
        }
        this.open = new XMLStartElement(uri, localName);
    }

    public XMLEndElement(StartElementToken token) throws NullPointerException {
        if (token == null) {
            throw new NullPointerException("Element must have a name.");
        }
        this.open = token;
    }

    @Override
    public String getName() {
        return this.open.getName();
    }

    @Override
    public String getNamespaceURI() {
        return this.open.getNamespaceURI();
    }

    @Override
    public StartElementToken getOpenElement() {
        return this.open;
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public boolean match(StartElementToken token) {
        if (token == null) {
            return false;
        }
        if (token == this.open) {
            return true;
        }
        return token.getNamespaceURI().equals(this.getNamespaceURI()) && token.getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return 89 + this.open.hashCode();
    }

    @Override
    public boolean equals(XMLToken token) {
        if (token == this) {
            return true;
        }
        if (!(token instanceof EndElementToken)) {
            return false;
        }
        if (this.hashCode() != token.hashCode()) {
            return false;
        }
        EndElementToken other = (EndElementToken)token;
        return other.getName().equals(this.getName()) && other.getNamespaceURI().equals(this.getNamespaceURI());
    }

    public String toString() {
        if (this.open.getNamespaceURI().isEmpty()) {
            return "</" + this.getName() + '>';
        }
        return "</{" + this.getNamespaceURI() + "}:" + this.getName() + '>';
    }
}

