/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.io.IOException;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.xmlwriter.XMLWriter;

public final class XMLComment
extends TokenBase
implements XMLToken {
    private final String comment;
    private final int hashCode;

    public XMLComment(String comment) throws NullPointerException {
        this.comment = Objects.requireNonNull(comment, "Comment must not be null, use \"\" instead");
        this.hashCode = XMLComment.toHashcode(comment);
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(XMLToken token) {
        if (token == null) {
            return false;
        }
        if (token.getClass() != this.getClass()) {
            return false;
        }
        XMLComment other = (XMLComment)token;
        return other.comment.equals(this.comment);
    }

    public String toString() {
        return "comment: " + this.comment;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.writeComment(this.comment);
    }

    @Override
    public void toXML(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeComment(this.comment);
    }

    @Override
    public XMLTokenType getType() {
        return XMLTokenType.COMMENT;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getValue() {
        return this.comment;
    }

    private static int toHashcode(String comment) {
        return 703 + comment.hashCode();
    }
}

