/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.handler;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.handler.DiffFilter;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.impl.CharactersToken;

public final class CoalescingFilter
extends DiffFilter<XMLToken>
implements DiffHandler<XMLToken> {
    private final List<TextToken> buffer = new ArrayList<TextToken>();
    private final List<TextToken> altBuffer = new ArrayList<TextToken>();
    private Operator current = Operator.MATCH;

    public CoalescingFilter(DiffHandler<XMLToken> target) {
        super(target);
    }

    @Override
    public void handle(@NotNull Operator operator, @NotNull XMLToken token) throws IllegalStateException {
        if (token instanceof TextToken) {
            this.handleText((TextToken)token, operator);
        } else {
            this.flushText();
            this.target.handle(operator, token);
        }
    }

    @Override
    public void end() {
        this.flushText();
        this.target.end();
    }

    private void handleText(@NotNull TextToken token, @NotNull Operator operator) {
        if (this.current == operator) {
            this.buffer.add(token);
        } else if (this.current == Operator.MATCH || operator == Operator.MATCH) {
            this.flushText();
            this.current = operator;
            this.buffer.add(token);
        } else {
            this.altBuffer.add(token);
        }
    }

    public void flushText() {
        if (this.buffer.size() > 0) {
            TextToken text = CoalescingFilter.coalesceText(this.buffer);
            this.target.handle(this.current, text);
            this.buffer.clear();
        }
        if (this.current != Operator.MATCH && !this.altBuffer.isEmpty()) {
            TextToken other = CoalescingFilter.coalesceText(this.altBuffer);
            this.target.handle(this.current.flip(), other);
            this.altBuffer.clear();
        }
    }

    public static TextToken coalesceText(@NotNull List<TextToken> tokens) {
        if (tokens.size() == 1) {
            return tokens.get(0);
        }
        StringBuilder text = new StringBuilder();
        for (TextToken token : tokens) {
            text.append(token.getCharacters());
        }
        return new CharactersToken(text.toString());
    }

    public static List<? extends XMLToken> coalesce(@NotNull List<? extends XMLToken> tokens) {
        if (tokens.size() <= 1) {
            return tokens;
        }
        ArrayList coalesced = new ArrayList();
        CoalescingFilter filter = new CoalescingFilter((operator, token) -> coalesced.add(token));
        for (XMLToken xMLToken : tokens) {
            filter.handle(Operator.MATCH, xMLToken);
        }
        return coalesced;
    }

    public String toString() {
        return "CoalescingFilter -> " + this.target;
    }
}

