/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.core;

import java.util.Iterator;
import java.util.List;
import org.pageseeder.diffx.algorithm.HirschbergAlgorithm;
import org.pageseeder.diffx.algorithm.KumarRanganAlgorithm;
import org.pageseeder.diffx.algorithm.MyersGreedyAlgorithm;
import org.pageseeder.diffx.algorithm.MyersLinearAlgorithm;
import org.pageseeder.diffx.algorithm.WagnerFischerAlgorithm;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.core.DiffProcessor;

public final class TextOnlyProcessor<T>
implements DiffProcessor<T> {
    private final Algorithm algo;

    public TextOnlyProcessor() {
        this(Algorithm.KUMAR_RANGAN);
    }

    public TextOnlyProcessor(Algorithm algorithm) {
        this.algo = algorithm;
    }

    @Override
    public void diff(List<? extends T> from, List<? extends T> to, DiffHandler<T> handler) {
        handler.start();
        if (from.isEmpty() || to.isEmpty()) {
            for (T token : to) {
                handler.handle(Operator.INS, token);
            }
            for (T token : from) {
                handler.handle(Operator.DEL, token);
            }
        } else {
            Slicer<T> slicer = new Slicer<T>(from, to);
            slicer.analyze();
            int startCount = slicer.getStartCount();
            int endCount = slicer.getEndCount();
            if (startCount > 0) {
                for (int i = 0; i < startCount; ++i) {
                    handler.handle(Operator.MATCH, from.get(i));
                }
            }
            if (startCount > 0 || endCount > 0) {
                List<T> subA = from.subList(startCount, from.size() - endCount);
                List<T> subB = to.subList(startCount, to.size() - endCount);
                if (subA.isEmpty() || subB.isEmpty()) {
                    for (T token : subB) {
                        handler.handle(Operator.INS, token);
                    }
                    for (T token : subA) {
                        handler.handle(Operator.DEL, token);
                    }
                } else {
                    DiffAlgorithm<T> algorithm = this.getAlgorithm();
                    algorithm.diff(subA, subB, handler);
                }
            } else {
                DiffAlgorithm<T> algorithm = this.getAlgorithm();
                algorithm.diff(from, to, handler);
            }
            if (endCount > 0) {
                for (int i = from.size() - endCount; i < from.size(); ++i) {
                    handler.handle(Operator.MATCH, from.get(i));
                }
            }
        }
        handler.end();
    }

    public String toString() {
        return "TextOnlyProcessor{algo=" + this.getAlgorithm().getClass().getSimpleName() + "}";
    }

    private DiffAlgorithm<T> getAlgorithm() {
        switch (this.algo) {
            case HIRSCHBERG: {
                return new HirschbergAlgorithm();
            }
            case WAGNER_FISCHER: {
                return new WagnerFischerAlgorithm();
            }
            case KUMAR_RANGAN: {
                return new KumarRanganAlgorithm();
            }
            case MYER_GREEDY: {
                return new MyersGreedyAlgorithm();
            }
            case MYER_LINEAR: {
                return new MyersLinearAlgorithm();
            }
        }
        throw new IllegalStateException("No algorithm defined");
    }

    private static final class Slicer<T> {
        final List<? extends T> a;
        final List<? extends T> b;
        int startCount = -1;
        int endCount = -1;

        public Slicer(List<? extends T> a, List<? extends T> b) {
            this.a = a;
            this.b = b;
        }

        public int analyze() throws IllegalStateException {
            this.startCount = this.computeStart();
            this.endCount = this.sliceEnd(this.startCount);
            return this.startCount + this.endCount;
        }

        int computeStart() {
            int counter = 0;
            Iterator<T> i = this.a.iterator();
            Iterator<T> j = this.b.iterator();
            while (i.hasNext() && j.hasNext() && j.next().equals(i.next())) {
                ++counter;
            }
            return counter;
        }

        public int sliceEnd(int start) {
            T token;
            int counter = 0;
            int pos1 = this.a.size() - 1;
            for (int pos2 = this.b.size() - 1; pos1 >= start && pos2 >= start && (token = this.a.get(pos1)).equals(this.b.get(pos2)); --pos1, --pos2) {
                ++counter;
            }
            return counter;
        }

        public int getStartCount() {
            return this.startCount;
        }

        public int getEndCount() {
            return this.endCount;
        }
    }

    public static enum Algorithm {
        HIRSCHBERG,
        WAGNER_FISCHER,
        KUMAR_RANGAN,
        MYER_GREEDY,
        MYER_LINEAR;

    }
}

