/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.List;
import org.pageseeder.diffx.algorithm.Matrix;
import org.pageseeder.diffx.algorithm.MatrixProcessor;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;

public final class WagnerFischerAlgorithm<T>
implements DiffAlgorithm<T> {
    @Override
    public void diff(List<? extends T> from, List<? extends T> to, DiffHandler<T> handler) {
        MatrixProcessor<T> builder = new MatrixProcessor<T>();
        builder.setInverse(true);
        Matrix matrix = builder.process(from, to);
        int length1 = from.size();
        int length2 = to.size();
        int i = 0;
        int j = 0;
        while (i < length1 && j < length2) {
            T t1 = from.get(i);
            T t2 = to.get(j);
            if (matrix.isGreaterX(i, j)) {
                handler.handle(Operator.DEL, t1);
                ++i;
                continue;
            }
            if (matrix.isGreaterY(i, j)) {
                handler.handle(Operator.INS, t2);
                ++j;
                continue;
            }
            if (!matrix.isSameXY(i, j)) continue;
            if (t1.equals(t2)) {
                handler.handle(Operator.MATCH, t1);
                ++i;
                ++j;
                continue;
            }
            handler.handle(Operator.DEL, t1);
            ++i;
        }
        while (i < length1) {
            handler.handle(Operator.DEL, from.get(i));
            ++i;
        }
        while (j < length2) {
            handler.handle(Operator.INS, to.get(j));
            ++j;
        }
    }
}

