/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.Arrays;

final class Vector {
    private final int[] array;
    private final boolean isForward;
    private final int max;
    private int delta;

    private Vector(int[] array, boolean forward, int max, int delta) {
        this.array = array;
        this.isForward = forward;
        this.max = max;
        this.delta = delta;
    }

    public void setX(int k, int x) {
        this.array[k - this.delta + this.max] = x;
    }

    public int getX(int k) {
        return this.array[k - this.delta + this.max];
    }

    public static Vector createLinear(int m, int n, boolean forward) {
        return Vector.create(m, n, forward, (m + n) / 2 + 1);
    }

    public static Vector createGreedy(int m, int n) {
        return Vector.create(m, n, true, m + n);
    }

    public static Vector create(int m, int n, boolean forward, int max) {
        if (max <= 0) {
            max = 1;
        }
        int[] array = new int[2 * max + 1];
        Vector vector = new Vector(array, forward, max, 0);
        vector.init(m, n);
        return vector;
    }

    public void init(int n, int m) {
        if (this.isForward) {
            this.setX(1, 0);
        } else {
            this.delta = n - m;
            this.setX(n - m - 1, n);
        }
    }

    public Vector snapshot(int d) {
        return this.snapshot(d, true, 0);
    }

    public Vector snapshot(int d, boolean isForward, int delta) {
        assert (!isForward || delta == 0);
        if (d == 0) {
            ++d;
        }
        if (d > this.max) {
            throw new IllegalArgumentException("D cannot exceed the maximum number of end points");
        }
        int[] array = new int[2 * d + 1];
        System.arraycopy(this.array, this.max - this.delta - (d - delta), array, 0, array.length);
        return new Vector(array, isForward, d, isForward ? 0 : delta);
    }

    public String toString() {
        return "V " + this.array.length + " {" + (this.delta - this.max) + ".." + this.delta + ".." + (this.delta + this.max) + "} " + Arrays.toString(this.array);
    }
}

