/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.List;
import org.pageseeder.diffx.algorithm.DataLengthException;
import org.pageseeder.diffx.algorithm.ElementStackFilter;
import org.pageseeder.diffx.algorithm.Matrix;
import org.pageseeder.diffx.algorithm.MatrixProcessor;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.sequence.TokenListSlicer;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.XMLToken;

public final class MatrixXMLAlgorithm
implements DiffAlgorithm<XMLToken> {
    public static final int DEFAULT_THRESHOLD = 64000000;
    private static final boolean DEBUG = false;
    private boolean slice = true;
    private int threshold = 64000000;

    public void setSlice(boolean slice) {
        this.slice = slice;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean isDiffComputable(List<? extends XMLToken> from, List<? extends XMLToken> to) {
        if (from.size() * to.size() <= this.threshold) {
            return true;
        }
        TokenListSlicer slicer = new TokenListSlicer(from, to);
        int commonCount = this.slice ? slicer.analyze() : 0;
        int matrixSize = (from.size() - commonCount) * (to.size() - commonCount);
        return matrixSize > this.threshold;
    }

    @Override
    public void diff(List<? extends XMLToken> from, List<? extends XMLToken> to, DiffHandler<XMLToken> handler) {
        int lengthA = from.size();
        int lengthB = to.size();
        if (lengthA == 0 || lengthB == 0) {
            for (XMLToken xMLToken : to) {
                handler.handle(Operator.INS, xMLToken);
            }
            for (XMLToken xMLToken : from) {
                handler.handle(Operator.DEL, xMLToken);
            }
            return;
        }
        ElementStackFilter estate = new ElementStackFilter(handler);
        this.diff(from, to, estate);
    }

    private void diff(List<? extends XMLToken> A, List<? extends XMLToken> B, ElementStackFilter handler) {
        int common;
        TokenListSlicer slicer = new TokenListSlicer(A, B);
        int n = common = this.slice ? slicer.analyze() : 0;
        if (common > 0) {
            slicer.handleStart(handler);
            List<? extends XMLToken> subA = slicer.getSubSequence1();
            List<? extends XMLToken> subB = slicer.getSubSequence2();
            if (subA.isEmpty() || subB.isEmpty()) {
                for (XMLToken xMLToken : subB) {
                    handler.handle(Operator.INS, xMLToken);
                }
                for (XMLToken xMLToken : subA) {
                    handler.handle(Operator.DEL, xMLToken);
                }
            } else {
                this.processDiff(subA, subB, handler);
            }
            slicer.handleEnd(handler);
        } else {
            this.processDiff(A, B, handler);
        }
    }

    private void processDiff(List<? extends XMLToken> A, List<? extends XMLToken> B, ElementStackFilter handler) {
        int lengthB;
        int lengthA = A.size();
        if (lengthA * (lengthB = B.size()) > this.threshold) {
            throw new DataLengthException(lengthA * lengthB, this.threshold);
        }
        MatrixProcessor<? extends XMLToken> builder = new MatrixProcessor<XMLToken>();
        builder.setInverse(true);
        Matrix matrix = builder.process(A, B);
        int i = 0;
        int j = 0;
        while (i < lengthA && j < lengthB) {
            XMLToken tokenA = A.get(i);
            XMLToken tokenB = B.get(j);
            if (matrix.isGreaterX(i, j)) {
                if (handler.isAllowed(Operator.DEL, tokenA) && !handler.hasPriorityOver(tokenB, tokenA)) {
                    handler.handle(Operator.DEL, tokenA);
                    ++i;
                    continue;
                }
                if (tokenA.equals(tokenB) && handler.isAllowed(Operator.MATCH, tokenA)) {
                    handler.handle(Operator.MATCH, tokenA);
                    ++i;
                    ++j;
                    continue;
                }
                if (!handler.isAllowed(Operator.INS, tokenB)) break;
                handler.handle(Operator.INS, tokenB);
                ++j;
                continue;
            }
            if (matrix.isGreaterY(i, j)) {
                if (handler.isAllowed(Operator.INS, tokenB) && !handler.hasPriorityOver(tokenA, tokenB)) {
                    handler.handle(Operator.INS, tokenB);
                    ++j;
                    continue;
                }
                if (tokenA.equals(tokenB) && handler.isAllowed(Operator.MATCH, tokenA)) {
                    handler.handle(Operator.MATCH, tokenA);
                    ++i;
                    ++j;
                    continue;
                }
                if (!handler.isAllowed(Operator.DEL, tokenA)) break;
                handler.handle(Operator.DEL, tokenA);
                ++i;
                continue;
            }
            if (!matrix.isSameXY(i, j)) break;
            if (tokenA.equals(tokenB) && handler.isAllowed(Operator.MATCH, tokenA)) {
                handler.handle(Operator.MATCH, tokenA);
                ++i;
                ++j;
                continue;
            }
            if (handler.isAllowed(Operator.DEL, tokenA) && (!(tokenB instanceof AttributeToken) || tokenA instanceof AttributeToken)) {
                handler.handle(Operator.DEL, tokenA);
                ++i;
                continue;
            }
            if (!handler.isAllowed(Operator.INS, tokenB) || tokenA instanceof AttributeToken && !(tokenB instanceof AttributeToken)) break;
            handler.handle(Operator.INS, tokenB);
            ++j;
        }
        while (i < lengthA) {
            handler.handle(Operator.DEL, A.get(i));
            ++i;
        }
        while (j < lengthB) {
            handler.handle(Operator.INS, B.get(j));
            ++j;
        }
    }

    private void printLost(int i, int j, Matrix matrix, ElementStackFilter estate, List<? extends XMLToken> first, List<? extends XMLToken> second) {
        XMLToken tokenA = first.get(i);
        XMLToken tokenB = second.get(j);
        System.err.println("(!) Ambiguous choice in (" + i + "," + j + ")");
        System.err.println(" ? +" + tokenA);
        System.err.println(" ? -" + tokenB);
        System.err.println(" current=" + estate.current());
        System.err.println(" value in X+1=" + matrix.get(i + 1, j));
        System.err.println(" value in Y+1=" + matrix.get(i, j + 1));
        System.err.println(" equals=" + tokenA.equals(tokenB));
        System.err.println(" greaterX=" + matrix.isGreaterX(i, j));
        System.err.println(" greaterY=" + matrix.isGreaterY(i, j));
        System.err.println(" sameXY=" + matrix.isSameXY(i, j));
        System.err.println(" okFormat1=" + estate.isAllowed(Operator.MATCH, tokenA));
        System.err.println(" okFormat2=" + estate.isAllowed(Operator.MATCH, tokenB));
        System.err.println(" okDelete=" + estate.isAllowed(Operator.DEL, tokenA));
        System.err.println(" okInsert=" + estate.isAllowed(Operator.INS, tokenB));
    }

    public String toString() {
        return "MatrixXMLAlgorithm{slice=" + this.slice + ", threshold=" + this.threshold + '}';
    }
}

