/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.io.PrintStream;
import java.util.List;
import org.pageseeder.diffx.algorithm.InvMatrixInt;
import org.pageseeder.diffx.algorithm.InvMatrixShort;
import org.pageseeder.diffx.algorithm.Matrix;
import org.pageseeder.diffx.algorithm.MatrixInt;
import org.pageseeder.diffx.algorithm.MatrixShort;
import org.pageseeder.diffx.xml.Sequence;

public final class MatrixProcessor<T> {
    private static final boolean DEBUG = false;
    private boolean inverse = false;

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public Matrix process(Sequence first, Sequence second) {
        Matrix matrix = this.inverse ? MatrixProcessor.computeInverse(first.tokens(), second.tokens()) : MatrixProcessor.compute(first.tokens(), second.tokens());
        return matrix;
    }

    public Matrix process(List<? extends T> first, List<? extends T> second) {
        Matrix matrix = this.inverse ? MatrixProcessor.computeInverse(first, second) : MatrixProcessor.compute(first, second);
        return matrix;
    }

    private static <T> Matrix compute(List<? extends T> first, List<? extends T> second) {
        Matrix matrix = MatrixProcessor.getMatrix(first, second, false);
        int length1 = first.size();
        int length2 = second.size();
        matrix.setup(length1 + 1, length2 + 1);
        for (int i = 0; i < length1 + 1; ++i) {
            for (int j = 0; j < length2 + 1; ++j) {
                if (i == 0 || j == 0) {
                    matrix.set(i, j, 0);
                    continue;
                }
                if (first.get(i - 1).equals(second.get(j - 1))) {
                    matrix.incrementPath(i, j);
                    continue;
                }
                matrix.incrementByMaxPath(i, j);
            }
        }
        return matrix;
    }

    private static <T> Matrix computeInverse(List<? extends T> first, List<? extends T> second) {
        Matrix matrix = MatrixProcessor.getMatrix(first, second, true);
        int length1 = first.size();
        int length2 = second.size();
        matrix.setup(length1 + 1, length2 + 1);
        for (int i = length1; i >= 0; --i) {
            for (int j = length2; j >= 0; --j) {
                if (i >= length1 || j >= length2) {
                    matrix.set(i, j, 0);
                    continue;
                }
                if (first.get(i).equals(second.get(j))) {
                    matrix.incrementPath(i, j);
                    continue;
                }
                matrix.incrementByMaxPath(i, j);
            }
        }
        return matrix;
    }

    private static <T> void printDebug(List<? extends T> first, List<? extends T> second, Matrix matrix, PrintStream out) {
        out.print("A:");
        for (T token : first) {
            out.print(token + "\t");
        }
        out.println();
        out.print("B:");
        for (T token : second) {
            out.print(token + "\t");
        }
        out.println();
        out.println(matrix);
    }

    private static <T> Matrix getMatrix(List<? extends T> first, List<? extends T> second, boolean inverse) {
        if (first.size() + 1 > Short.MAX_VALUE || second.size() + 1 > Short.MAX_VALUE) {
            return inverse ? new InvMatrixInt() : new MatrixInt();
        }
        return inverse ? new InvMatrixShort() : new MatrixShort();
    }
}

