/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.action;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;

public class OperationsBuffer<T>
implements DiffHandler<T> {
    private final List<Operation<T>> operations = new ArrayList<Operation<T>>();

    @Override
    public void handle(@NotNull Operator operator, @NotNull T token) {
        this.operations.add(new Operation<T>(operator, token));
    }

    public List<Operation<T>> getOperations() {
        return this.operations;
    }

    public int countEdits() {
        int edits = 0;
        for (Operation<T> op : this.operations) {
            if (!op.operator().isEdit()) continue;
            ++edits;
        }
        return edits;
    }

    public String toString() {
        return "OperationsBuffer";
    }

    public void applyTo(DiffHandler<T> handler) {
        handler.start();
        for (Operation<T> operation : this.operations) {
            handler.handle(operation.operator(), operation.token());
        }
        handler.end();
    }
}

