/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.action;

import java.util.List;
import org.pageseeder.diffx.action.Action;
import org.pageseeder.diffx.action.Actions;
import org.pageseeder.diffx.api.Operator;

public final class DiffResult<T> {
    private final List<Action<T>> actions;

    public DiffResult(List<Action<T>> actions) {
        this.actions = actions;
    }

    public List<Action<T>> actions() {
        return this.actions;
    }

    public DiffResult<T> reverse() {
        return new DiffResult<T>(Actions.flip(this.actions));
    }

    public boolean isApplicableTo(List<T> to, List<T> from) {
        return Actions.isApplicable(to, from, this.actions);
    }

    public List<T> apply(List<T> tokens) {
        return Actions.apply(tokens, this.actions);
    }

    public boolean hasChanges() {
        return this.actions.stream().anyMatch(action -> action.operator() != Operator.MATCH);
    }

    public boolean isIdentical() {
        return this.actions.stream().noneMatch(action -> action.operator() != Operator.MATCH);
    }

    public int countEvents(Operator operator) {
        return this.actions.stream().filter(action -> action.operator() == operator).mapToInt(action -> action.tokens().size()).sum();
    }
}

