/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.action;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.action.Action;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;

public class ActionsBuffer<T>
implements DiffHandler<T> {
    private final List<Action<T>> actions = new ArrayList<Action<T>>();
    private Action<T> action = null;

    @Override
    public void handle(@NotNull Operator operator, @NotNull T token) {
        this.setupAction(operator);
        this.action.add(token);
    }

    public List<Action<T>> getActions() {
        return this.actions;
    }

    public int countEdits() {
        int edits = 0;
        for (Action<T> action : this.actions) {
            if (!action.operator().isEdit()) continue;
            edits += action.tokens().size();
        }
        return edits;
    }

    private void setupAction(Operator operator) {
        if (this.action == null || this.action.operator() != operator) {
            this.action = new Action(operator);
            this.actions.add(this.action);
        }
    }

    public void applyTo(DiffHandler<T> handler) {
        handler.start();
        for (Action<T> action : this.actions) {
            for (T token : action.tokens()) {
                handler.handle(action.operator(), token);
            }
        }
        handler.end();
    }

    public String toString() {
        return "ActionsBuffer";
    }
}

