/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.action;

import java.util.ArrayList;
import java.util.List;
import org.pageseeder.diffx.action.Action;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.xml.Sequence;

public class Actions {
    public static <T> List<T> generate(List<Action<T>> actions, boolean forward) {
        ArrayList<T> generated = new ArrayList<T>();
        for (Action<T> action : actions) {
            if (forward ? action.operator() == Operator.INS : action.operator() == Operator.DEL) {
                generated.addAll(action.tokens());
                continue;
            }
            if (action.operator() != Operator.MATCH) continue;
            generated.addAll(action.tokens());
        }
        return generated;
    }

    public static <T> List<Operation<T>> toOperations(List<Action<T>> actions) {
        ArrayList<Operation<T>> operations = new ArrayList<Operation<T>>();
        for (Action<T> action : actions) {
            Operator operator = action.operator();
            for (T token : action.tokens()) {
                operations.add(new Operation<T>(operator, token));
            }
        }
        return operations;
    }

    public static <T> List<Action<T>> flip(List<Action<T>> actions) {
        ArrayList<Action<T>> reverse = new ArrayList<Action<T>>(actions.size());
        for (Action<T> action : actions) {
            reverse.add(action.flip());
        }
        return reverse;
    }

    public static Sequence apply(Sequence input, List<Action<XMLToken>> actions) {
        List<XMLToken> tokens = Actions.apply(input.tokens(), actions);
        Sequence out = new Sequence(tokens.size());
        tokens.forEach(out::addToken);
        return out;
    }

    public static <T> List<T> apply(List<T> input, List<Action<T>> actions) {
        ArrayList<T> out = new ArrayList<T>(input.size());
        int i = 0;
        try {
            for (Action<T> action : actions) {
                int count = action.tokens().size();
                switch (action.operator()) {
                    case MATCH: {
                        out.addAll(input.subList(i, i + count));
                        i += count;
                        break;
                    }
                    case INS: {
                        out.addAll(action.tokens());
                        break;
                    }
                    case DEL: {
                        i += count;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Actions cannot be applied to specified input", ex);
        }
        if (i != input.size()) {
            throw new IllegalArgumentException("Actions do not match specified input");
        }
        return out;
    }

    public static <T> boolean isApplicable(List<? extends T> a, List<? extends T> b, List<Action<T>> actions) {
        int i = 0;
        int j = 0;
        for (Action<T> action : actions) {
            if (action.operator() == Operator.MATCH) {
                for (T token : action.tokens()) {
                    if (i >= a.size() || !token.equals(a.get(i))) {
                        return false;
                    }
                    if (j >= b.size() || !token.equals(b.get(j))) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
                continue;
            }
            if (action.operator() == Operator.DEL) {
                for (T token : action.tokens()) {
                    if (i >= a.size() || !token.equals(a.get(i))) {
                        return false;
                    }
                    ++i;
                }
                continue;
            }
            if (action.operator() != Operator.INS) continue;
            for (T token : action.tokens()) {
                if (j >= b.size() || !token.equals(b.get(j))) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    public static <T> void handle(List<Action<T>> actions, DiffHandler<T> handler) {
        for (Action<T> action : actions) {
            for (T token : action.tokens()) {
                handler.handle(action.operator(), token);
            }
        }
    }

    public static <T> void applyTo(List<Action<T>> actions, DiffHandler<T> handler) {
        handler.start();
        for (Action<T> action : actions) {
            for (T token : action.tokens()) {
                handler.handle(action.operator(), token);
            }
        }
        handler.end();
    }
}

