/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.diffx.token.ElementToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.Token;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.xmlwriter.XMLWriter;

public class XMLElement
extends TokenBase
implements ElementToken {
    private final List<Token> tokens = new ArrayList<Token>();
    private final int hashCode;

    public XMLElement(StartElementToken open, EndElementToken close, List<Token> children) {
        this.tokens.add(open);
        this.tokens.addAll(children);
        this.tokens.add(close);
        this.hashCode = XMLElement.toHashCode(this.tokens);
    }

    @Override
    public String getName() {
        return ((StartElementToken)this.tokens.get(0)).getName();
    }

    @Override
    public String getNamespaceURI() {
        return ((StartElementToken)this.tokens.get(0)).getNamespaceURI();
    }

    @Override
    public List<Token> getEvents() {
        return this.tokens;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Token token) {
        if (token.getClass() != this.getClass()) {
            return false;
        }
        XMLElement element = (XMLElement)token;
        if (element.hashCode != this.hashCode) {
            return false;
        }
        if (element.tokens.size() != this.tokens.size()) {
            return false;
        }
        return element.tokens.equals(this.tokens);
    }

    public String toString() {
        return "element: " + this.getName();
    }

    public void toXML(XMLWriter xml) throws IOException {
        for (Token token : this.tokens) {
            token.toXML(xml);
        }
    }

    @Override
    public void toXML(XMLStreamWriter xml) throws XMLStreamException {
        for (Token token : this.tokens) {
            token.toXML(xml);
        }
    }

    private static int toHashCode(List<Token> tokens) {
        int result = 1;
        for (Token token : tokens) {
            result = 31 * result + (token == null ? 0 : token.hashCode());
        }
        return result;
    }
}

