/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.diffx.token.Token;
import org.pageseeder.diffx.token.TokenType;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.xmlwriter.XMLWriter;

public final class XMLBranchToken
extends TokenBase
implements Token {
    private final Token[] branch;
    private final int hashCode;

    public XMLBranchToken(Token[] tokens) {
        this.branch = tokens;
        this.hashCode = XMLBranchToken.toHashCode(tokens);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Token token) {
        if (token.getClass() != this.getClass()) {
            return false;
        }
        if (token.hashCode() != this.hashCode) {
            return false;
        }
        XMLBranchToken be = (XMLBranchToken)token;
        if (this.branch.length != be.branch.length) {
            return false;
        }
        for (int i = 0; i < this.branch.length; ++i) {
            if (be.branch[i].equals(this.branch[i])) continue;
            return false;
        }
        return true;
    }

    public void toXML(XMLWriter xml) throws IOException {
        for (Token element : this.branch) {
            element.toXML(xml);
        }
    }

    @Override
    public void toXML(XMLStreamWriter xml) throws XMLStreamException {
        for (Token element : this.branch) {
            element.toXML(xml);
        }
    }

    @Override
    public TokenType getType() {
        return TokenType.ELEMENT;
    }

    private static int toHashCode(Token[] tokens) {
        int hash = 17;
        for (Token token : tokens) {
            hash = hash * 13 + (token != null ? token.hashCode() : 0);
        }
        return hash;
    }
}

