/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.io.IOException;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.diffx.token.Token;
import org.pageseeder.diffx.token.TokenType;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.xmlwriter.XMLWriter;

public final class CommentToken
extends TokenBase
implements Token {
    private final String comment;
    private final int hashCode;

    public CommentToken(String comment) throws NullPointerException {
        this.comment = Objects.requireNonNull(comment, "Comment must not be null, use \"\" instead");
        this.hashCode = CommentToken.toHashcode(comment);
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Token token) {
        if (token == null) {
            return false;
        }
        if (token.getClass() != this.getClass()) {
            return false;
        }
        CommentToken other = (CommentToken)token;
        return other.comment.equals(this.comment);
    }

    public String toString() {
        return "comment: " + this.comment;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.writeComment(this.comment);
    }

    @Override
    public void toXML(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeComment(this.comment);
    }

    @Override
    public TokenType getType() {
        return TokenType.OTHER;
    }

    private static int toHashcode(String comment) {
        return 703 + comment.hashCode();
    }
}

