/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token;

import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.impl.XMLAttribute;
import org.pageseeder.diffx.token.impl.XMLEndElement;
import org.pageseeder.diffx.token.impl.XMLStartElement;

public final class TokenFactory {
    private final boolean isNamespaceAware;

    public TokenFactory() {
        this.isNamespaceAware = true;
    }

    public TokenFactory(boolean isNamespaceAware) {
        this.isNamespaceAware = isNamespaceAware;
    }

    public boolean isNamespaceAware() {
        return this.isNamespaceAware;
    }

    public StartElementToken newStartElement(String uri, String name) {
        return this.isNamespaceAware ? new XMLStartElement(uri, name) : new XMLStartElement(name);
    }

    public StartElementToken newStartElement(String uri, String localName, String qName) {
        return this.isNamespaceAware ? new XMLStartElement(uri, localName) : new XMLStartElement(qName);
    }

    public EndElementToken newEndElement(StartElementToken open) {
        return new XMLEndElement(open);
    }

    public AttributeToken newAttribute(String name, String value) {
        return new XMLAttribute(name, value);
    }

    public AttributeToken newAttribute(String uri, String name, String value) {
        return this.isNamespaceAware ? new XMLAttribute(uri, name, value) : new XMLAttribute(name, value);
    }

    public AttributeToken newAttribute(String uri, String localName, String qName, String value) {
        return this.isNamespaceAware ? new XMLAttribute(uri, localName, value) : new XMLAttribute(qName, value);
    }
}

