/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.sequence;

import java.util.ArrayList;
import java.util.Stack;
import org.pageseeder.diffx.sequence.Sequence;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.Token;
import org.pageseeder.diffx.token.impl.TextListToken;

public final class Sequences {
    private Sequences() {
    }

    public static boolean isWellFormed(Sequence sequence) {
        if (sequence == null) {
            return false;
        }
        Stack<Token> open = new Stack<Token>();
        for (int i = 0; i < sequence.size(); ++i) {
            Token token = sequence.getToken(i);
            if (token instanceof StartElementToken) {
                open.push(token);
                continue;
            }
            if (!(token instanceof EndElementToken)) continue;
            if (open.empty()) {
                return false;
            }
            StartElementToken o = (StartElementToken)open.peek();
            String lastOpenElementName = o.getName();
            String closeElementName = ((EndElementToken)token).getName();
            if (closeElementName.equals(lastOpenElementName)) continue;
            return false;
        }
        return open.empty();
    }

    public static int getMaxDepth(Sequence sequence) {
        int max = 0;
        int depth = 0;
        for (int i = 0; i < sequence.size(); ++i) {
            if (sequence.getToken(i) instanceof StartElementToken) {
                ++depth;
            } else if (sequence.getToken(i) instanceof EndElementToken) {
                --depth;
            }
            if (depth <= max) continue;
            max = depth;
        }
        return max;
    }

    public static int getMaxElementContent(Sequence sequence) {
        int max = 0;
        int tmp = 0;
        for (int i = 0; i < sequence.size(); ++i) {
            Token token = sequence.getToken(i);
            if (token instanceof StartElementToken) {
                tmp = 0;
                continue;
            }
            if (token instanceof EndElementToken) {
                if (tmp <= max) continue;
                max = tmp;
                continue;
            }
            ++tmp;
        }
        return max;
    }

    public static Sequence foldText(Sequence input) {
        ArrayList<TextToken> text = new ArrayList<TextToken>();
        Sequence output = new Sequence(input.getNamespaces());
        for (Token token : input) {
            if (token instanceof TextToken) {
                text.add((TextToken)token);
                continue;
            }
            if (text.size() > 1) {
                output.addToken(new TextListToken(text));
                text.clear();
            } else if (text.size() == 1) {
                output.addToken((Token)text.remove(0));
            }
            output.addToken(token);
        }
        return output;
    }
}

