/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.sequence;

import java.io.IOException;
import java.util.Iterator;
import org.pageseeder.diffx.format.DiffXFormatter;
import org.pageseeder.diffx.sequence.EventSequence;
import org.pageseeder.diffx.sequence.Sequence;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.Token;

public final class SequenceSlicer {
    final Sequence sequence1;
    final Sequence sequence2;
    Sequence start;
    Sequence end;

    @Deprecated
    public SequenceSlicer(EventSequence seq0, EventSequence seq1) {
        this.sequence1 = seq0.sequence;
        this.sequence2 = seq1.sequence;
    }

    public SequenceSlicer(Sequence seq0, Sequence seq1) {
        this.sequence1 = seq0;
        this.sequence2 = seq1;
    }

    public void slice() throws IllegalStateException {
        this.sliceStart();
        this.sliceEnd();
    }

    public int sliceStart() throws IllegalStateException {
        if (this.start != null) {
            throw new IllegalStateException("The start buffer already contains a subsequence.");
        }
        this.start = new Sequence();
        int toBeRemoved = 0;
        int depth = 0;
        Iterator<Token> i = this.sequence1.iterator();
        Iterator<Token> j = this.sequence2.iterator();
        int counter = 0;
        while (i.hasNext() && j.hasNext()) {
            Token token = i.next();
            if (!j.next().equals(token)) break;
            ++counter;
            if (token instanceof StartElementToken) {
                ++depth;
            } else if (token instanceof EndElementToken) {
                --depth;
            }
            if (depth != 1 && depth != 0) continue;
            toBeRemoved = counter;
        }
        for (int k = 0; k < toBeRemoved; ++k) {
            Token token = this.sequence1.removeToken(0);
            this.sequence2.removeToken(0);
            this.start.addToken(token);
        }
        return toBeRemoved;
    }

    public int sliceEnd() throws IllegalStateException {
        int k;
        Token token;
        if (this.end != null) {
            throw new IllegalStateException("The end buffer already contains a subsequence.");
        }
        this.end = new Sequence();
        int depth = 0;
        int toBeRemoved = 0;
        int counter = 0;
        int pos1 = this.sequence1.size() - 1;
        for (int pos2 = this.sequence2.size() - 1; pos1 >= 0 && pos2 >= 0 && (token = this.sequence1.getToken(pos1)).equals(this.sequence2.getToken(pos2)); --pos1, --pos2) {
            ++counter;
            if (token instanceof EndElementToken) {
                ++depth;
            } else if (token instanceof StartElementToken) {
                --depth;
            }
            if (depth != 1 && depth != 0) continue;
            toBeRemoved = counter;
        }
        int downTo = this.sequence1.size() - toBeRemoved;
        for (k = this.sequence1.size() - 1; k >= downTo; --k) {
            Token token2 = this.sequence1.removeToken(k);
            this.end.addToken(0, token2);
        }
        downTo = this.sequence2.size() - toBeRemoved;
        for (k = this.sequence2.size() - 1; k >= downTo; --k) {
            this.sequence2.removeToken(k);
        }
        return toBeRemoved;
    }

    public void formatStart(DiffXFormatter formatter) throws NullPointerException, IOException {
        if (this.start == null) {
            return;
        }
        for (int i = 0; i < this.start.size(); ++i) {
            formatter.format(this.start.getToken(i));
        }
        this.start = null;
    }

    public void formatEnd(DiffXFormatter formatter) throws NullPointerException, IOException {
        if (this.end == null) {
            return;
        }
        for (int i = 0; i < this.end.size(); ++i) {
            formatter.format(this.end.getToken(i));
        }
        this.end = null;
    }

    public Sequence getStart() {
        return this.start;
    }

    public Sequence getEnd() {
        return this.end;
    }
}

