/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.sequence;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pageseeder.diffx.token.Token;
import org.pageseeder.diffx.xml.NamespaceSet;

public final class Sequence
implements Iterable<Token> {
    private final NamespaceSet namespaces = new NamespaceSet();
    private final List<Token> tokens;

    public Sequence() {
        this.tokens = new ArrayList<Token>();
    }

    public Sequence(int size) {
        this.tokens = new ArrayList<Token>(size);
    }

    public Sequence(NamespaceSet namespaces) {
        this.tokens = new ArrayList<Token>();
        this.namespaces.add(namespaces);
    }

    public Sequence(List<Token> tokens) {
        this.tokens = tokens;
    }

    public void addSequence(Sequence seq) {
        this.tokens.addAll(seq.tokens);
    }

    public void addToken(Token token) {
        this.tokens.add(token);
    }

    public void addToken(int i, Token token) {
        this.tokens.add(i, token);
    }

    public void addTokens(List<? extends Token> tokens) {
        this.tokens.addAll(tokens);
    }

    public Token getToken(int i) {
        return this.tokens.get(i);
    }

    public Token setToken(int index, Token token) {
        return this.tokens.set(index, token);
    }

    public Token removeToken(int index) {
        return this.tokens.remove(index);
    }

    public int size() {
        return this.tokens.size();
    }

    public List<Token> tokens() {
        return this.tokens;
    }

    public int hashCode() {
        return this.tokens.size();
    }

    public boolean equals(Sequence seq) {
        if (seq == null) {
            return false;
        }
        return Sequence.equals(this.tokens, seq.tokens);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Sequence)) {
            return false;
        }
        return this.equals((Sequence)o);
    }

    public String toString() {
        return "Sequence{namespaces=" + this.namespaces + ", tokens=" + this.tokens + '}';
    }

    public void export(PrintWriter w) {
        for (Token token : this.tokens) {
            w.println(token.toString());
        }
        w.flush();
    }

    @Deprecated
    public void mapPrefix(String uri, String prefix) throws NullPointerException {
        this.namespaces.add(uri, prefix);
    }

    public void addNamespace(String uri, String prefix, boolean replace) throws NullPointerException {
        if (replace) {
            this.namespaces.replace(uri, prefix);
        } else {
            this.namespaces.add(uri, prefix);
        }
    }

    public void addNamespace(String uri, String prefix) throws NullPointerException {
        this.namespaces.add(uri, prefix);
    }

    public NamespaceSet getNamespaces() {
        return this.namespaces;
    }

    @Override
    public Iterator<Token> iterator() {
        return this.tokens().iterator();
    }

    private static boolean equals(List<Token> first, List<Token> second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            Token x2;
            Token x1 = first.get(i);
            if (x1.equals(x2 = second.get(i))) continue;
            return false;
        }
        return true;
    }
}

