/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.sequence;

import java.io.IOException;
import java.util.Iterator;
import org.pageseeder.diffx.format.DiffXFormatter;
import org.pageseeder.diffx.sequence.Sequence;
import org.pageseeder.diffx.token.Token;

public final class NaiveSequenceSlicer {
    final Sequence sequence1;
    final Sequence sequence2;
    Sequence start;
    Sequence end;

    public NaiveSequenceSlicer(Sequence seq0, Sequence seq1) {
        this.sequence1 = seq0;
        this.sequence2 = seq1;
    }

    public int sliceStart() throws IllegalStateException {
        if (this.start != null) {
            throw new IllegalStateException("The start buffer already contains a subsequence.");
        }
        this.start = new Sequence();
        int count = 0;
        Iterator<Token> i = this.sequence1.iterator();
        Iterator<Token> j = this.sequence2.iterator();
        while (i.hasNext() && j.hasNext()) {
            Token token = i.next();
            if (j.next().equals(token)) {
                ++count;
                i.remove();
                j.remove();
                this.start.addToken(token);
                continue;
            }
            return count;
        }
        return count;
    }

    public int sliceEnd() throws IllegalStateException {
        Token token1;
        if (this.end != null) {
            throw new IllegalStateException("The end buffer already contains a subsequence.");
        }
        this.end = new Sequence();
        int count = 0;
        int pos1 = this.sequence1.size() - 1;
        int pos2 = this.sequence2.size() - 1;
        while (pos1 >= 0 && pos2 >= 0 && (token1 = this.sequence1.getToken(pos1)).equals(this.sequence2.getToken(pos2))) {
            ++count;
            this.sequence1.removeToken(pos1--);
            this.sequence2.removeToken(pos2--);
            this.end.addToken(0, token1);
        }
        return count;
    }

    public int sliceStart(DiffXFormatter formatter) throws IllegalStateException, NullPointerException, IOException {
        if (this.start != null) {
            throw new IllegalStateException("The start buffer already contains a subsequence.");
        }
        int count = 0;
        Iterator<Token> i = this.sequence1.iterator();
        Iterator<Token> j = this.sequence2.iterator();
        while (i.hasNext() && j.hasNext()) {
            Token token = i.next();
            if (!j.next().equals(token)) break;
            ++count;
            i.remove();
            j.remove();
            formatter.format(token);
        }
        return count;
    }

    public int sliceEnd(DiffXFormatter formatter) throws IllegalStateException, NullPointerException, IOException {
        int count = this.sliceEnd();
        this.formatEnd(formatter);
        return count;
    }

    public void formatStart(DiffXFormatter formatter) throws NullPointerException, IOException {
        if (this.start == null) {
            return;
        }
        for (int i = 0; i < this.start.size(); ++i) {
            formatter.format(this.start.getToken(i));
        }
        this.start = null;
    }

    public void formatEnd(DiffXFormatter formatter) throws NullPointerException, IOException {
        if (this.end == null) {
            return;
        }
        for (int i = 0; i < this.end.size(); ++i) {
            formatter.format(this.end.getToken(i));
        }
        this.end = null;
    }

    public Sequence getStart() {
        return this.start;
    }

    public Sequence getEnd() {
        return this.end;
    }
}

