/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.load.text;

import org.pageseeder.diffx.config.DiffConfig;
import org.pageseeder.diffx.config.DiffXConfig;
import org.pageseeder.diffx.config.TextGranularity;
import org.pageseeder.diffx.load.text.TextTokenizer;
import org.pageseeder.diffx.load.text.TokenizerByChar;
import org.pageseeder.diffx.load.text.TokenizerByPunctuation;
import org.pageseeder.diffx.load.text.TokenizerBySpaceWord;
import org.pageseeder.diffx.load.text.TokenizerByText;
import org.pageseeder.diffx.load.text.TokenizerByWord;

public final class TokenizerFactory {
    private TokenizerFactory() {
    }

    public static TextTokenizer get(DiffConfig config) {
        if (config == null) {
            throw new NullPointerException("The config should be specified");
        }
        TextGranularity granularity = config.granularity();
        switch (granularity) {
            case CHARACTER: {
                return new TokenizerByChar();
            }
            case WORD: {
                return new TokenizerByWord(config.whitespace());
            }
            case SPACE_WORD: {
                return new TokenizerBySpaceWord(config.whitespace());
            }
            case PUNCTUATION: {
                return new TokenizerByPunctuation(config.whitespace());
            }
            case TEXT: {
                return new TokenizerByText(config.whitespace());
            }
        }
        throw new IllegalArgumentException("Unsupported text granularity " + (Object)((Object)granularity));
    }

    @Deprecated
    public static TextTokenizer get(DiffXConfig config) {
        if (config == null) {
            throw new NullPointerException("The config should be specified");
        }
        return TokenizerFactory.get(config.toDiffConfig());
    }
}

