/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.load;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import org.pageseeder.diffx.load.Loader;
import org.pageseeder.diffx.load.LoadingException;
import org.pageseeder.diffx.sequence.Sequence;
import org.xml.sax.InputSource;

public interface XMLLoader
extends Loader {
    public Sequence load(InputSource var1) throws LoadingException, IOException;

    @Override
    default public Sequence load(File file) throws LoadingException, IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            Sequence sequence = this.load(new InputSource(in));
            return sequence;
        }
    }

    @Override
    default public Sequence load(File file, Charset charset) throws LoadingException, IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));){
            Sequence sequence = this.load(new InputSource(reader));
            return sequence;
        }
    }

    @Override
    default public Sequence load(Reader reader) throws LoadingException, IOException {
        return this.load(new InputSource(reader));
    }

    @Override
    default public Sequence load(String source) throws LoadingException {
        try {
            return this.load(new InputSource(new StringReader(source)));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

