/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.load;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.pageseeder.diffx.load.AttributeComparator;
import org.pageseeder.diffx.load.LoadingException;
import org.pageseeder.diffx.load.XMLLoader;
import org.pageseeder.diffx.load.XMLLoaderBase;
import org.pageseeder.diffx.load.XMLStreamLoader;
import org.pageseeder.diffx.load.text.TextTokenizer;
import org.pageseeder.diffx.load.text.TokenizerFactory;
import org.pageseeder.diffx.sequence.Sequence;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.TokenFactory;
import org.pageseeder.diffx.token.impl.CommentToken;
import org.pageseeder.diffx.token.impl.IgnorableSpaceToken;
import org.pageseeder.diffx.token.impl.ProcessingInstructionToken;
import org.pageseeder.diffx.token.impl.SpaceToken;
import org.pageseeder.diffx.token.impl.XMLAttribute;
import org.xml.sax.InputSource;

public final class XMLEventLoader
extends XMLLoaderBase
implements XMLLoader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Sequence load(File file) throws LoadingException, IOException {
        XMLInputFactory factory = XMLStreamLoader.toFactory(this.config);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            XMLEventReader reader = factory.createXMLEventReader(in);
            Sequence sequence = this.load(reader);
            return sequence;
        }
        catch (XMLStreamException ex) {
            throw new LoadingException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Sequence load(String xml) throws LoadingException {
        XMLInputFactory factory = XMLStreamLoader.toFactory(this.config);
        try (StringReader source = new StringReader(xml);){
            XMLEventReader reader = factory.createXMLEventReader(source);
            Sequence sequence = this.load(reader);
            return sequence;
        }
        catch (XMLStreamException ex) {
            throw new LoadingException(ex);
        }
    }

    @Override
    public Sequence load(InputSource source) throws LoadingException, IOException {
        XMLInputFactory factory = XMLStreamLoader.toFactory(this.config);
        try {
            XMLEventReader reader = XMLEventLoader.toXMLEventReader(factory, source);
            return this.load(reader);
        }
        catch (XMLStreamException ex) {
            throw new LoadingException(ex);
        }
    }

    public Sequence load(XMLEventReader reader) throws LoadingException {
        TokenFactory tokenFactory = new TokenFactory(this.config.isNamespaceAware());
        AttributeComparator comparator = new AttributeComparator();
        TextTokenizer tokenizer = TokenizerFactory.get(this.config);
        ArrayList<StartElementToken> startElements = new ArrayList<StartElementToken>();
        Sequence sequence = new Sequence();
        sequence.addNamespace("http://www.w3.org/XML/1998/namespace", "xml");
        sequence.addNamespace("", "");
        try {
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    XMLEventLoader.processNamespaces(event.asStartElement(), sequence);
                    XMLEventLoader.processStartElement(event.asStartElement(), sequence, tokenFactory, startElements);
                    XMLEventLoader.processAttributes(event.asStartElement(), sequence, this.config.isNamespaceAware(), comparator);
                    continue;
                }
                if (event.isEndElement()) {
                    XMLEventLoader.processEndElement(event.asEndElement(), sequence, tokenFactory, startElements);
                    continue;
                }
                if (event.isCharacters()) {
                    XMLEventLoader.processText(event.asCharacters(), sequence, tokenizer);
                    continue;
                }
                XMLEventLoader.processOther(event, sequence);
            }
        }
        catch (XMLStreamException ex) {
            throw new LoadingException(ex);
        }
        return sequence;
    }

    private static void processNamespaces(StartElement event, Sequence sequence) {
        Iterator<Namespace> ns = event.getNamespaces();
        while (ns.hasNext()) {
            Namespace namespace = ns.next();
            sequence.addNamespace(namespace.getNamespaceURI(), namespace.getPrefix());
        }
    }

    private static void processStartElement(StartElement event, Sequence sequence, TokenFactory factory, List<StartElementToken> startElements) {
        QName name = event.getName();
        StartElementToken startElement = factory.newStartElement(name.getNamespaceURI(), name.getLocalPart());
        sequence.addToken(startElement);
        startElements.add(startElement);
    }

    private static void processAttributes(StartElement event, Sequence sequence, boolean namespaceAware, AttributeComparator comparator) {
        ArrayList<AttributeToken> attributes = null;
        Iterator<Attribute> it = event.getAttributes();
        while (it.hasNext()) {
            Attribute attribute = it.next();
            if (attributes == null) {
                attributes = new ArrayList<AttributeToken>();
            }
            attributes.add(XMLEventLoader.toAttribute(attribute, namespaceAware));
        }
        if (attributes != null) {
            if (attributes.size() > 1) {
                attributes.sort(comparator);
            }
            for (AttributeToken token : attributes) {
                sequence.addToken(token);
            }
        }
    }

    private static void processEndElement(EndElement event, Sequence sequence, TokenFactory factory, List<StartElementToken> startElements) {
        StartElementToken startElement = startElements.remove(startElements.size() - 1);
        EndElementToken endElement = factory.newEndElement(startElement);
        sequence.addToken(endElement);
    }

    private static void processText(Characters event, Sequence sequence, TextTokenizer tokenizer) {
        if (event.isIgnorableWhiteSpace()) {
            sequence.addToken(new IgnorableSpaceToken(event.getData()));
        } else if (event.isWhiteSpace()) {
            sequence.addToken(new SpaceToken(event.getData()));
        } else {
            sequence.addTokens(tokenizer.tokenize(event.getData()));
        }
    }

    private static void processOther(XMLEvent event, Sequence sequence) {
        if (event.isProcessingInstruction()) {
            ProcessingInstruction instruction = (ProcessingInstruction)event;
            ProcessingInstructionToken token = new ProcessingInstructionToken(instruction.getTarget(), instruction.getData());
            sequence.addToken(token);
        } else if (event.getEventType() == 5) {
            CommentToken token = new CommentToken(((Comment)event).getText());
            sequence.addToken(token);
        }
    }

    private static AttributeToken toAttribute(Attribute attribute, boolean namespaceAware) {
        QName name = attribute.getName();
        if (namespaceAware) {
            return new XMLAttribute(name.getNamespaceURI(), name.getLocalPart(), attribute.getValue());
        }
        if (name.getPrefix().isEmpty()) {
            return new XMLAttribute(name.getLocalPart(), attribute.getValue());
        }
        return new XMLAttribute(name.getPrefix() + ":" + name.getLocalPart(), attribute.getValue());
    }

    private static XMLEventReader toXMLEventReader(XMLInputFactory factory, InputSource source) throws XMLStreamException, LoadingException {
        if (source.getByteStream() != null) {
            String encoding = Objects.toString(source.getEncoding(), "utf-8");
            return factory.createXMLEventReader(source.getByteStream(), encoding);
        }
        if (source.getCharacterStream() != null) {
            return factory.createXMLEventReader(source.getSystemId(), source.getCharacterStream());
        }
        throw new LoadingException("Invalid InputSource");
    }
}

