/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import org.pageseeder.diffx.load.Loader;
import org.pageseeder.diffx.sequence.Sequence;
import org.pageseeder.diffx.token.impl.LineToken;

public final class LineLoader
implements Loader {
    @Override
    public Sequence load(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            Sequence sequence = this.getSequence(reader);
            return sequence;
        }
    }

    @Override
    public Sequence load(File file, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));){
            Sequence sequence = this.getSequence(reader);
            return sequence;
        }
    }

    @Override
    public Sequence load(Reader reader) throws IOException {
        try (BufferedReader buffer = new BufferedReader(reader);){
            Sequence sequence = this.getSequence(buffer);
            return sequence;
        }
    }

    @Override
    public Sequence load(String text) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(text));
            return this.getSequence(reader);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private Sequence getSequence(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        int count = 0;
        Sequence sequence = new Sequence();
        while (line != null) {
            sequence.addToken(new LineToken(line, ++count));
            line = reader.readLine();
        }
        return sequence;
    }
}

