/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.load;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.pageseeder.diffx.load.AttributeComparator;
import org.pageseeder.diffx.load.LoadingException;
import org.pageseeder.diffx.load.XMLLoader;
import org.pageseeder.diffx.load.XMLLoaderBase;
import org.pageseeder.diffx.load.text.TextTokenizer;
import org.pageseeder.diffx.load.text.TokenizerFactory;
import org.pageseeder.diffx.sequence.Sequence;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.TokenFactory;
import org.pageseeder.diffx.token.impl.CommentToken;
import org.pageseeder.diffx.token.impl.ProcessingInstructionToken;
import org.pageseeder.diffx.xml.NamespaceSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public final class DOMLoader
extends XMLLoaderBase
implements XMLLoader {
    private TokenFactory tokenFactory;
    private TextTokenizer tokenizer;
    private Sequence sequence;
    private NamespaceSet namespaces;
    private boolean isFragment = true;

    @Override
    public Sequence load(String xml) throws LoadingException {
        return this.load(new InputSource(new StringReader(xml)));
    }

    @Override
    public Sequence load(InputSource is) throws LoadingException {
        this.isFragment = false;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(this.config.isNamespaceAware());
        dbFactory.setExpandEntityReferences(true);
        dbFactory.setValidating(false);
        try {
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document document = builder.parse(is);
            return this.load(document);
        }
        catch (Exception ex) {
            throw new LoadingException(ex);
        }
    }

    public Sequence load(Node node) throws LoadingException {
        this.tokenFactory = new TokenFactory(this.config.isNamespaceAware());
        this.tokenizer = TokenizerFactory.get(this.config);
        this.sequence = new Sequence();
        this.namespaces = this.sequence.getNamespaces();
        this.loadNode(node);
        this.isFragment = node.getNodeType() != 9;
        return this.sequence;
    }

    public Sequence load(NodeList node) throws LoadingException {
        if (node.getLength() == 0) {
            return new Sequence();
        }
        return this.load(node.item(0));
    }

    private void loadNode(Node node) throws LoadingException {
        if (node instanceof Element) {
            this.loadElement((Element)node);
        } else if (node instanceof Text) {
            this.loadText((Text)node);
        } else if (node instanceof Document) {
            this.loadDocument((Document)node);
        } else if (node instanceof ProcessingInstruction) {
            this.loadPI((ProcessingInstruction)node);
        } else if (node instanceof Comment) {
            this.loadComment((Comment)node);
        }
    }

    private void loadDocument(Document document) throws LoadingException {
        this.loadElement(document.getDocumentElement());
    }

    private void loadElement(Element element) throws LoadingException {
        StartElementToken start = this.toStartElement(element);
        this.sequence.addToken(start);
        this.loadAttributes(element);
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.loadNode(list.item(i));
        }
        EndElementToken close = this.tokenFactory.newEndElement(start);
        this.sequence.addToken(close);
    }

    private void loadText(Text text) {
        List<TextToken> tokens = this.tokenizer.tokenize(text.getData());
        for (TextToken token : tokens) {
            this.sequence.addToken(token);
        }
    }

    private void loadPI(ProcessingInstruction pi) {
        this.sequence.addToken(new ProcessingInstructionToken(pi.getTarget(), pi.getData()));
    }

    private void loadComment(Comment comment) {
        this.sequence.addToken(new CommentToken(comment.getTextContent()));
    }

    private void handlePrefixMapping(String uri, String prefix) {
        if (this.isFragment) {
            if (this.namespaces.getPrefix(uri) != null) {
                return;
            }
            if (prefix == null && !"".equals(uri)) {
                this.namespaces.add(uri, "");
            } else if (prefix != null && !"xmlns".equals(prefix)) {
                this.namespaces.add(uri, prefix);
            }
        }
    }

    private StartElementToken toStartElement(Element element) {
        if (this.config.isNamespaceAware()) {
            String uri = element.getNamespaceURI() != null ? element.getNamespaceURI() : "";
            this.handlePrefixMapping(uri, element.getPrefix());
            return this.tokenFactory.newStartElement(uri, element.getLocalName());
        }
        return this.tokenFactory.newStartElement("", element.getNodeName());
    }

    private void loadAttributes(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        if (attributes.getLength() == 1) {
            AttributeToken token = this.toAttribute((Attr)attributes.item(0));
            if (token != null) {
                this.sequence.addToken(token);
            }
        } else if (attributes.getLength() > 1) {
            ArrayList<AttributeToken> tokens = new ArrayList<AttributeToken>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                AttributeToken token = this.toAttribute((Attr)attributes.item(i));
                if (token == null) continue;
                tokens.add(token);
            }
            tokens.sort(new AttributeComparator());
            this.sequence.addTokens(tokens);
        }
    }

    private AttributeToken toAttribute(Attr attr) {
        String uri = attr.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        this.handlePrefixMapping(uri, attr.getPrefix());
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            this.sequence.addNamespace(attr.getValue(), attr.getLocalName());
            return null;
        }
        if (this.config.isNamespaceAware()) {
            return this.tokenFactory.newAttribute(uri, attr.getLocalName(), attr.getValue());
        }
        return this.tokenFactory.newAttribute(attr.getNodeName(), attr.getValue());
    }
}

