/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.handler;

import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.handler.DiffFilter;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.Token;
import org.pageseeder.diffx.token.TokenType;
import org.pageseeder.diffx.token.impl.XMLEndElement;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PostXMLFixer
extends DiffFilter {
    private static final Token NIL = new NilToken();
    private final Deque<StartOperation> unclosed = new ArrayDeque<StartOperation>();
    private final Queue<Token> deletions = new ArrayDeque<Token>();
    private final Queue<Token> insertions = new ArrayDeque<Token>();
    private Operator lastOperator = Operator.MATCH;
    private Token lastToken = NIL;
    private boolean hasError = false;

    public PostXMLFixer(DiffHandler handler) {
        super(handler);
    }

    @Override
    public void handle(Operator operator, Token token) throws UncheckedIOException, IllegalStateException {
        if (operator == Operator.DEL) {
            this.deletions.add(token);
        } else if (operator == Operator.INS) {
            this.insertions.add(token);
        } else {
            this.flushChanges();
            if (token.getType() == TokenType.END_ELEMENT && !this.matchStart(Operator.MATCH, (EndElementToken)token)) {
                this.sendMatchingEndElement();
            } else {
                this.send(operator, token);
            }
        }
    }

    private void flushChanges() {
        while (!this.insertions.isEmpty() || !this.deletions.isEmpty()) {
            if (this.lastToken.getType() == TokenType.START_ELEMENT || this.lastToken.getType() == TokenType.ATTRIBUTE) {
                while (PostXMLFixer.isAttribute(this.insertions.peek())) {
                    this.send(Operator.INS, this.insertions.remove());
                }
                while (PostXMLFixer.isAttribute(this.deletions.peek())) {
                    this.send(Operator.DEL, this.deletions.remove());
                }
            }
            Token nextInsertion = this.insertions.peek();
            Token nextDeletion = this.deletions.peek();
            if (PostXMLFixer.isEndElement(nextInsertion) && this.matchStart(Operator.INS, (EndElementToken)nextInsertion)) {
                this.send(Operator.INS, this.insertions.remove());
                continue;
            }
            if (PostXMLFixer.isEndElement(nextDeletion) && this.matchStart(Operator.DEL, (EndElementToken)nextDeletion)) {
                this.send(Operator.DEL, this.deletions.remove());
                continue;
            }
            if (PostXMLFixer.isEndElement(nextInsertion)) {
                this.hasError = true;
                this.sendMatchingEndElement();
                this.insertions.remove();
                continue;
            }
            if (PostXMLFixer.isEndElement(nextDeletion)) {
                this.hasError = true;
                this.sendMatchingEndElement();
                this.deletions.remove();
                continue;
            }
            if (this.lastOperator == Operator.INS && nextInsertion != null) {
                this.send(Operator.INS, this.insertions.remove());
                continue;
            }
            if (this.lastOperator == Operator.DEL && nextDeletion != null) {
                this.send(Operator.DEL, this.deletions.remove());
                continue;
            }
            if (nextInsertion != null) {
                this.send(Operator.INS, this.insertions.remove());
                continue;
            }
            if (nextDeletion == null) continue;
            this.send(Operator.DEL, this.deletions.remove());
        }
    }

    public boolean hasError() {
        return this.hasError;
    }

    private static boolean isEndElement(Token token) {
        return token != null && token.getType() == TokenType.END_ELEMENT;
    }

    private static boolean isAttribute(Token token) {
        return token != null && token.getType() == TokenType.ATTRIBUTE;
    }

    private boolean matchStart(Operator operator, EndElementToken token) {
        StartOperation op = this.unclosed.peek();
        if (op == null) {
            return false;
        }
        return op.operator == operator && token.match(op.token);
    }

    private void sendMatchingEndElement() {
        StartOperation lastStart = this.unclosed.peek();
        if (lastStart != null) {
            EndElementToken end = this.toEndElementToken(lastStart.token);
            this.send(lastStart.operator, end);
        }
    }

    private EndElementToken toEndElementToken(StartElementToken token) {
        return new XMLEndElement(token);
    }

    private void send(Operator operator, Token token) {
        this.target.handle(operator, token);
        this.lastOperator = operator;
        this.lastToken = token;
        if (token.getType() == TokenType.START_ELEMENT) {
            this.unclosed.push(new StartOperation(operator, (StartElementToken)token));
        } else if (token.getType() == TokenType.END_ELEMENT) {
            this.unclosed.pop();
        }
    }

    @Override
    public void end() {
        this.flushChanges();
    }

    private static class NilToken
    implements Token {
        private NilToken() {
        }

        @Override
        public TokenType getType() {
            return TokenType.OTHER;
        }

        @Override
        public boolean equals(Token token) {
            return token == this;
        }

        public void toXML(XMLWriter xml) {
        }

        @Override
        public void toXML(XMLStreamWriter xml) {
        }
    }

    private static class StartOperation {
        private final Operator operator;
        private final StartElementToken token;

        StartOperation(Operator operator, StartElementToken token) {
            this.operator = operator;
            this.token = token;
        }

        public Operator operator() {
            return this.operator;
        }

        public StartElementToken token() {
            return this.token;
        }
    }
}

