/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.handler;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.format.DiffXFormatter;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.token.Token;

public class FormattingAdapter
implements DiffHandler {
    protected final DiffXFormatter formatter;

    public FormattingAdapter(DiffXFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public void handle(Operator operator, Token token) throws UncheckedIOException {
        try {
            switch (operator) {
                case MATCH: {
                    this.formatter.format(token);
                    break;
                }
                case INS: {
                    this.formatter.insert(token);
                    break;
                }
                case DEL: {
                    this.formatter.delete(token);
                    break;
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String toString() {
        return "FormattingAdapter(" + this.formatter + ")";
    }
}

