/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.handler;

import java.util.List;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.config.WhiteSpaceProcessing;
import org.pageseeder.diffx.core.TextOnlyProcessor;
import org.pageseeder.diffx.handler.DiffFilter;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.load.text.TextTokenizer;
import org.pageseeder.diffx.load.text.TokenizerBySpaceWord;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.Token;

public final class CompareReplaceFilter
extends DiffFilter
implements DiffHandler {
    private final TextTokenizer tokenizer = new TokenizerBySpaceWord(WhiteSpaceProcessing.PRESERVE);
    private Operation previous = null;

    public CompareReplaceFilter(DiffHandler target) {
        super(target);
    }

    @Override
    public void handle(Operator operator, Token token) {
        if (token instanceof TextToken && operator.isEdit()) {
            if (this.previous != null) {
                this.diff((TextToken)token, (TextToken)this.previous.token(), operator == Operator.INS);
                this.previous = null;
            } else {
                this.flushPrevious();
                this.previous = new Operation(operator, token);
            }
        } else {
            this.flushPrevious();
            this.target.handle(operator, token);
        }
    }

    private void diff(TextToken a, TextToken b, boolean positive) {
        List<TextToken> tokensA = this.tokenizer.tokenize(a.getCharacters());
        List<TextToken> tokensB = this.tokenizer.tokenize(b.getCharacters());
        TextOnlyProcessor diff = new TextOnlyProcessor();
        if (positive) {
            diff.diff(tokensA, tokensB, this.target);
        } else {
            diff.diff(tokensB, tokensA, this.target);
        }
    }

    public void flushPrevious() {
        if (this.previous != null) {
            this.target.handle(this.previous.operator(), this.previous.token());
            this.previous = null;
        }
    }

    @Override
    public void end() {
        this.flushPrevious();
        this.target.end();
    }

    public String toString() {
        return "CompareReplaceFilter -> " + this.target;
    }
}

