/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.handler;

import java.util.ArrayList;
import java.util.List;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.handler.DiffFilter;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.Token;
import org.pageseeder.diffx.token.impl.CharactersToken;

public final class CoalescingFilter
extends DiffFilter
implements DiffHandler {
    private final List<TextToken> buffer = new ArrayList<TextToken>();
    private final List<TextToken> altBuffer = new ArrayList<TextToken>();
    private Operator current = Operator.MATCH;

    public CoalescingFilter(DiffHandler target) {
        super(target);
    }

    @Override
    public void handle(Operator operator, Token token) throws IllegalStateException {
        if (token instanceof TextToken) {
            this.handleText((TextToken)token, operator);
        } else {
            this.flushText();
            this.target.handle(operator, token);
        }
    }

    @Override
    public void end() {
        this.flushText();
        this.target.end();
    }

    private void handleText(TextToken token, Operator operator) {
        if (this.current == operator) {
            this.buffer.add(token);
        } else if (this.current == Operator.MATCH || operator == Operator.MATCH) {
            this.flushText();
            this.current = operator;
            this.buffer.add(token);
        } else {
            this.altBuffer.add(token);
        }
    }

    public void flushText() {
        if (this.buffer.size() > 0) {
            TextToken text = CoalescingFilter.coalesceText(this.buffer);
            this.target.handle(this.current, text);
            this.buffer.clear();
        }
        if (this.current != Operator.MATCH && !this.altBuffer.isEmpty()) {
            TextToken other = CoalescingFilter.coalesceText(this.altBuffer);
            this.target.handle(this.current.flip(), other);
            this.altBuffer.clear();
        }
    }

    public static TextToken coalesceText(List<TextToken> tokens) {
        if (tokens.size() == 1) {
            return tokens.get(0);
        }
        StringBuilder text = new StringBuilder();
        for (TextToken token : tokens) {
            text.append(token.getCharacters());
        }
        return new CharactersToken(text.toString());
    }

    public static List<? extends Token> coalesce(List<? extends Token> tokens) {
        if (tokens.size() <= 1) {
            return tokens;
        }
        ArrayList coalesced = new ArrayList();
        CoalescingFilter filter = new CoalescingFilter((operator, token) -> coalesced.add(token));
        for (Token token2 : tokens) {
            filter.handle(Operator.MATCH, token2);
        }
        return coalesced;
    }

    public String toString() {
        return "CoalescingFilter -> " + this.target;
    }
}

