/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.handler;

import java.util.ArrayList;
import java.util.List;
import org.pageseeder.diffx.action.Action;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.token.Token;

public class ActionsBuffer
implements DiffHandler {
    private final List<Action> actions = new ArrayList<Action>();
    private Action action = null;

    @Override
    public void handle(Operator operator, Token token) {
        this.setupAction(operator);
        this.action.add(token);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    private void setupAction(Operator operator) {
        if (this.action == null || this.action.operator() != operator) {
            this.action = new Action(operator);
            this.actions.add(this.action);
        }
    }

    public void applyTo(DiffHandler handler) {
        handler.start();
        for (Action action : this.actions) {
            for (Token token : action.tokens()) {
                handler.handle(action.operator(), token);
            }
        }
        handler.end();
    }

    public String toString() {
        return "ActionsBuffer";
    }
}

