/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.format;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.format.XMLDiffOutput;
import org.pageseeder.diffx.format.XMLDiffOutputBase;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.Token;
import org.pageseeder.diffx.token.impl.SpaceToken;
import org.pageseeder.diffx.xml.Namespace;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;

public final class DefaultXMLDiffOutput
extends XMLDiffOutputBase
implements XMLDiffOutput {
    final XMLWriterNSImpl xml;

    public DefaultXMLDiffOutput() {
        this(new PrintWriter(System.out));
    }

    public DefaultXMLDiffOutput(Writer w) {
        this.xml = new XMLWriterNSImpl(w, false);
    }

    @Override
    public void start() {
        try {
            if (this.includeXMLDeclaration) {
                this.xml.xmlDecl();
            }
            this.declareNamespaces();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void handle(Operator operator, Token token) throws UncheckedIOException, IllegalStateException {
        try {
            if (operator.isEdit()) {
                this.handleEdit(operator, token);
            } else {
                this.handleMatch(token);
            }
            this.xml.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void end() {
        try {
            this.xml.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    void handleMatch(Token token) throws IOException {
        token.toXML((XMLWriter)this.xml);
    }

    void handleEdit(Operator operator, Token token) throws IOException {
        if (token instanceof StartElementToken) {
            token.toXML((XMLWriter)this.xml);
            this.xml.attribute(this.getDiffNamespace().getUri(), operator == Operator.INS ? "insert" : "delete", "true");
        } else if (token instanceof AttributeToken) {
            AttributeToken attribute = (AttributeToken)token;
            if (operator == Operator.INS) {
                token.toXML((XMLWriter)this.xml);
                if (this.hasNoPrefix(attribute)) {
                    this.xml.attribute(this.getDiffNamespace(Operator.INS).getUri(), attribute.getName(), "true");
                }
            } else if (this.hasNoPrefix(attribute)) {
                this.xml.attribute(this.getDiffNamespace(Operator.DEL).getUri(), attribute.getName(), attribute.getValue());
            }
        } else if (token == SpaceToken.NEW_LINE) {
            if (operator == Operator.INS) {
                token.toXML((XMLWriter)this.xml);
            }
        } else if (token instanceof TextToken) {
            this.xml.openElement(this.getDiffNamespace().getUri(), DefaultXMLDiffOutput.toElement(operator), false);
            token.toXML((XMLWriter)this.xml);
            this.xml.closeElement();
        } else if (token instanceof EndElementToken) {
            token.toXML((XMLWriter)this.xml);
        } else if (operator == Operator.INS) {
            token.toXML((XMLWriter)this.xml);
        }
    }

    private boolean hasNoPrefix(AttributeToken attribute) {
        if (attribute.getName().indexOf(58) != -1) {
            return false;
        }
        String prefix = this.namespaces.getPrefix(attribute.getNamespaceURI());
        return prefix == null || prefix.isEmpty();
    }

    private void declareNamespaces() {
        Namespace diffNamespace = this.getDiffNamespace();
        Namespace insNamespace = this.getDiffNamespace(Operator.INS);
        Namespace delNamespace = this.getDiffNamespace(Operator.DEL);
        this.xml.setPrefixMapping(diffNamespace.getUri(), diffNamespace.getPrefix());
        this.xml.setPrefixMapping(insNamespace.getUri(), insNamespace.getPrefix());
        this.xml.setPrefixMapping(delNamespace.getUri(), delNamespace.getPrefix());
        if (this.namespaces != null) {
            for (Namespace namespace : this.namespaces) {
                this.xml.setPrefixMapping(namespace.getUri(), namespace.getPrefix());
            }
        }
    }

    private static String toElement(Operator operator) {
        return operator == Operator.INS ? "ins" : "del";
    }
}

