/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.format;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.format.XMLDiffOutput;
import org.pageseeder.diffx.format.XMLDiffOutputBase;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.Token;
import org.pageseeder.diffx.token.impl.SpaceToken;
import org.pageseeder.diffx.xml.Namespace;
import org.pageseeder.diffx.xml.NamespaceSet;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;

public final class CompleteXMLDiffOutput
extends XMLDiffOutputBase
implements XMLDiffOutput {
    private final XMLWriter xml;
    private final List<AttributeToken> insertedAttributes = new ArrayList<AttributeToken>();
    private final List<AttributeToken> deletedAttributes = new ArrayList<AttributeToken>();
    private String diffNamespaceUri = this.getDiffNamespace().getUri();

    public CompleteXMLDiffOutput(Writer out) {
        this.xml = new XMLWriterNSImpl(out);
    }

    @Override
    public void start() {
        this.diffNamespaceUri = this.getDiffNamespace().getUri();
        try {
            if (this.includeXMLDeclaration) {
                this.xml.xmlDecl();
            }
            this.declareNamespaces();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void end() {
        try {
            this.xml.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void handle(Operator operator, Token token) throws UncheckedIOException, IllegalStateException {
        try {
            if (!(token instanceof AttributeToken)) {
                this.flushAttributes();
            }
            if (operator == Operator.MATCH) {
                this.handleMatch(token);
            } else {
                this.handleEdit(operator, token);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void handleMatch(Token token) throws IOException {
        token.toXML(this.xml);
    }

    private void handleEdit(Operator operator, Token token) throws IOException {
        if (token instanceof StartElementToken) {
            token.toXML(this.xml);
            this.xml.attribute(this.diffNamespaceUri, operator == Operator.INS ? "ins" : "del", "true");
        } else if (token == SpaceToken.NEW_LINE) {
            if (operator == Operator.INS) {
                token.toXML(this.xml);
            }
        } else if (token instanceof TextToken) {
            this.xml.openElement(this.diffNamespaceUri, operator == Operator.INS ? "ins" : "del", false);
            token.toXML(this.xml);
            this.xml.closeElement();
        } else if (token instanceof AttributeToken) {
            if (operator == Operator.INS) {
                token.toXML(this.xml);
                this.insertedAttributes.add((AttributeToken)token);
            } else {
                this.deletedAttributes.add((AttributeToken)token);
            }
        } else if (token instanceof EndElementToken) {
            token.toXML(this.xml);
        } else if (operator == Operator.INS) {
            token.toXML(this.xml);
        }
    }

    private void declareNamespaces() {
        Namespace diff = this.getDiffNamespace();
        this.xml.setPrefixMapping(diff.getUri(), diff.getPrefix());
        for (Namespace namespace : this.namespaces) {
            this.xml.setPrefixMapping(namespace.getUri(), namespace.getPrefix());
        }
    }

    private void flushAttributes() throws IOException {
        String names;
        if (!this.insertedAttributes.isEmpty()) {
            names = CompleteXMLDiffOutput.getQNames(this.insertedAttributes, this.namespaces);
            this.xml.attribute(this.diffNamespaceUri, "ins-attributes", names);
        }
        if (!this.deletedAttributes.isEmpty()) {
            names = CompleteXMLDiffOutput.getQNames(this.deletedAttributes, this.namespaces);
            this.xml.attribute(this.diffNamespaceUri, "del-attributes", names);
        }
        if (!this.insertedAttributes.isEmpty()) {
            this.xml.openElement(this.diffNamespaceUri, "ins", false);
            for (AttributeToken attribute : this.insertedAttributes) {
                this.xml.attribute(attribute.getNamespaceURI(), attribute.getName(), attribute.getValue());
            }
            this.xml.closeElement();
            this.insertedAttributes.clear();
        }
        if (!this.deletedAttributes.isEmpty()) {
            this.xml.openElement(this.diffNamespaceUri, "del", false);
            for (AttributeToken attribute : this.deletedAttributes) {
                this.xml.attribute(attribute.getNamespaceURI(), attribute.getName(), attribute.getValue());
            }
            this.xml.closeElement();
            this.deletedAttributes.clear();
        }
    }

    private static String getQNames(List<AttributeToken> attributes, NamespaceSet namespaces) {
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < attributes.size(); ++i) {
            if (i > 0) {
                names.append(' ');
            }
            names.append(CompleteXMLDiffOutput.getQName(attributes.get(i), namespaces));
        }
        return names.toString();
    }

    private static String getQName(AttributeToken attribute, NamespaceSet namespaces) {
        if (attribute.getName().indexOf(58) > 0) {
            return attribute.getName();
        }
        String prefix = namespaces.getPrefix(attribute.getNamespaceURI());
        return prefix != null && !prefix.isEmpty() ? prefix + ":" + attribute.getName() : attribute.getName();
    }
}

