/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.core;

import java.util.List;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.algorithm.DiffAlgorithm;
import org.pageseeder.diffx.algorithm.HirschbergAlgorithm;
import org.pageseeder.diffx.algorithm.KumarRanganAlgorithm;
import org.pageseeder.diffx.algorithm.WagnerFischerAlgorithm;
import org.pageseeder.diffx.core.DiffProcessor;
import org.pageseeder.diffx.core.DiffProcessorBase;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.sequence.TokenListSlicer;
import org.pageseeder.diffx.token.Token;

public final class TextOnlyProcessor
extends DiffProcessorBase
implements DiffProcessor {
    private final Algorithm algo;

    public TextOnlyProcessor() {
        this(Algorithm.KUMAR_RANGAN);
    }

    public TextOnlyProcessor(Algorithm algorithm) {
        this.algo = algorithm;
    }

    @Override
    public void diff(List<? extends Token> first, List<? extends Token> second, DiffHandler handler) {
        handler.start();
        if (first.isEmpty() || second.isEmpty()) {
            for (Token token : second) {
                handler.handle(Operator.DEL, token);
            }
            for (Token token : first) {
                handler.handle(Operator.INS, token);
            }
        } else {
            TokenListSlicer slicer = new TokenListSlicer(first, second);
            int n = slicer.analyze();
            int startCount = slicer.getStartCount();
            int endCount = slicer.getEndCount();
            if (startCount > 0) {
                for (int i = 0; i < startCount; ++i) {
                    handler.handle(Operator.MATCH, first.get(i));
                }
            }
            if (startCount > 0 || endCount > 0) {
                List<? extends Token> firstSub = first.subList(startCount, first.size() - endCount);
                List<? extends Token> secondSub = second.subList(startCount, second.size() - endCount);
                if (firstSub.isEmpty() || secondSub.isEmpty()) {
                    for (Token token : secondSub) {
                        handler.handle(Operator.DEL, token);
                    }
                    for (Token token : firstSub) {
                        handler.handle(Operator.INS, token);
                    }
                } else {
                    DiffAlgorithm algorithm = this.getAlgorithm();
                    algorithm.diff(firstSub, secondSub, handler);
                }
            } else {
                DiffAlgorithm algorithm = this.getAlgorithm();
                algorithm.diff(first, second, handler);
            }
            if (endCount > 0) {
                for (int i = first.size() - endCount; i < first.size(); ++i) {
                    handler.handle(Operator.MATCH, first.get(i));
                }
            }
        }
        handler.end();
    }

    public String toString() {
        return "TextOnlyProcessor{algo=" + this.getAlgorithm().getClass().getSimpleName() + "}";
    }

    private DiffAlgorithm getAlgorithm() {
        switch (this.algo) {
            case HIRSCHBERG: {
                return new HirschbergAlgorithm();
            }
            case WAGNER_FISCHER: {
                return new WagnerFischerAlgorithm();
            }
            case KUMAR_RANGAN: {
                return new KumarRanganAlgorithm();
            }
        }
        throw new IllegalStateException("No algorithm defined");
    }

    public static enum Algorithm {
        HIRSCHBERG,
        WAGNER_FISCHER,
        KUMAR_RANGAN;

    }
}

