/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.core;

import java.util.List;
import org.pageseeder.diffx.algorithm.DataLengthException;
import org.pageseeder.diffx.algorithm.KumarRanganAlgorithm;
import org.pageseeder.diffx.algorithm.MatrixXMLAlgorithm;
import org.pageseeder.diffx.core.DiffProcessor;
import org.pageseeder.diffx.core.DiffProcessorBase;
import org.pageseeder.diffx.handler.CoalescingFilter;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.handler.OperationsBuffer;
import org.pageseeder.diffx.handler.PostXMLFixer;
import org.pageseeder.diffx.token.Token;

public final class OptimisticXMLProcessor
extends DiffProcessorBase
implements DiffProcessor {
    private static final boolean DEBUG = false;
    private int fallbackThreshold = 64000000;
    private boolean isDownscaleAllowed = true;

    public void setDownscaleAllowed(boolean allowed) {
        this.isDownscaleAllowed = allowed;
    }

    boolean isDownscaleAllowed() {
        return this.isDownscaleAllowed;
    }

    public void setFallbackThreshold(int fallbackThreshold) {
        this.fallbackThreshold = fallbackThreshold;
    }

    @Override
    public void diff(List<? extends Token> first, List<? extends Token> second, DiffHandler handler) {
        OperationsBuffer buffer = new OperationsBuffer();
        boolean successful = this.fastDiff(first, second, buffer);
        if (successful) {
            buffer.applyTo(this.getFilter(handler));
        } else {
            this.fallbackDiff(first, second, this.getFilter(handler), false);
        }
    }

    private DiffHandler getFilter(DiffHandler handler) {
        return this.coalesce ? new CoalescingFilter(handler) : handler;
    }

    private boolean fastDiff(List<? extends Token> first, List<? extends Token> second, OperationsBuffer buffer) {
        KumarRanganAlgorithm algorithm = new KumarRanganAlgorithm();
        PostXMLFixer fixer = new PostXMLFixer(buffer);
        fixer.start();
        algorithm.diff(first, second, fixer);
        fixer.end();
        return !fixer.hasError();
    }

    private void fallbackDiff(List<? extends Token> first, List<? extends Token> second, DiffHandler handler, boolean coalesced) {
        MatrixXMLAlgorithm algorithm = new MatrixXMLAlgorithm();
        algorithm.setThreshold(this.fallbackThreshold);
        DiffHandler actual = this.getFilter(handler);
        if (algorithm.isDiffComputable(first, second)) {
            actual.start();
            algorithm.diff(first, second, actual);
            actual.end();
        } else if (!coalesced && this.isDownscaleAllowed) {
            List<? extends Token> a = CoalescingFilter.coalesce(first);
            List<? extends Token> b = CoalescingFilter.coalesce(second);
            this.fallbackDiff(a, b, handler, true);
        } else {
            throw new DataLengthException(first.size() * second.size(), this.fallbackThreshold);
        }
    }

    public String toString() {
        return "OptimisticXMLProcessor{coalesce=" + this.coalesce + ", fallbackThreshold=" + this.fallbackThreshold + '}';
    }
}

