/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.core;

import java.util.List;
import org.pageseeder.diffx.algorithm.MatrixXMLAlgorithm;
import org.pageseeder.diffx.core.DiffProcessor;
import org.pageseeder.diffx.core.DiffProcessorBase;
import org.pageseeder.diffx.handler.CoalescingFilter;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.token.Token;

public class DefaultXMLProcessor
extends DiffProcessorBase
implements DiffProcessor {
    private int threshold = 64000000;

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void setCoalesce(boolean coalesce) {
        this.coalesce = coalesce;
    }

    public boolean isDiffComputable(List<? extends Token> first, List<? extends Token> second) {
        MatrixXMLAlgorithm algorithm = new MatrixXMLAlgorithm();
        algorithm.setThreshold(this.threshold);
        return algorithm.isDiffComputable(first, second);
    }

    @Override
    public void diff(List<? extends Token> first, List<? extends Token> second, DiffHandler handler) {
        MatrixXMLAlgorithm algorithm = new MatrixXMLAlgorithm();
        algorithm.setThreshold(this.threshold);
        DiffHandler actual = this.getFilter(handler);
        handler.start();
        algorithm.diff(first, second, actual);
        handler.end();
    }

    private DiffHandler getFilter(DiffHandler handler) {
        return this.coalesce ? new CoalescingFilter(handler) : handler;
    }

    public String toString() {
        return "DefaultXMLProcessor{coalesce=" + this.coalesce + '}';
    }
}

