/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.config;

import org.pageseeder.diffx.config.TextGranularity;
import org.pageseeder.diffx.config.WhiteSpaceProcessing;

public final class DiffConfig {
    private final boolean isNamespaceAware;
    private final WhiteSpaceProcessing whitespace;
    private final TextGranularity granularity;

    public DiffConfig(WhiteSpaceProcessing whitespace, TextGranularity granularity) {
        this(true, whitespace, granularity);
    }

    public DiffConfig(boolean isNamespaceAware, WhiteSpaceProcessing whitespace, TextGranularity granularity) {
        this.isNamespaceAware = isNamespaceAware;
        this.whitespace = whitespace;
        this.granularity = granularity;
    }

    public boolean isNamespaceAware() {
        return this.isNamespaceAware;
    }

    public TextGranularity granularity() {
        return this.granularity;
    }

    public WhiteSpaceProcessing whitespace() {
        return this.whitespace;
    }

    public static DiffConfig getDefault() {
        return new DiffConfig(true, WhiteSpaceProcessing.COMPARE, TextGranularity.SPACE_WORD);
    }

    public static DiffConfig legacyDefault() {
        return new DiffConfig(true, WhiteSpaceProcessing.COMPARE, TextGranularity.WORD);
    }

    public DiffConfig granularity(TextGranularity granularity) {
        return new DiffConfig(this.isNamespaceAware, this.whitespace, granularity);
    }

    public DiffConfig whitespace(WhiteSpaceProcessing whitespace) {
        return new DiffConfig(this.isNamespaceAware, whitespace, this.granularity);
    }

    public DiffConfig noNamespaces() {
        return new DiffConfig(false, this.whitespace, this.granularity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffConfig that = (DiffConfig)o;
        if (this.isNamespaceAware != that.isNamespaceAware) {
            return false;
        }
        if (this.whitespace != that.whitespace) {
            return false;
        }
        return this.granularity == that.granularity;
    }

    public int hashCode() {
        int result = this.isNamespaceAware ? 1 : 0;
        result = 31 * result + this.whitespace.hashCode();
        result = 31 * result + this.granularity.hashCode();
        return result;
    }
}

