/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.List;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.algorithm.DiffAlgorithm;
import org.pageseeder.diffx.algorithm.Matrix;
import org.pageseeder.diffx.algorithm.MatrixProcessor;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.token.Token;

public final class WagnerFischerAlgorithm
implements DiffAlgorithm {
    @Override
    public void diff(List<? extends Token> first, List<? extends Token> second, DiffHandler handler) {
        MatrixProcessor builder = new MatrixProcessor();
        builder.setInverse(true);
        Matrix matrix = builder.process(first, second);
        int length1 = first.size();
        int length2 = second.size();
        int i = 0;
        int j = 0;
        while (i < length1 && j < length2) {
            Token t1 = first.get(i);
            Token t2 = second.get(j);
            if (matrix.isGreaterX(i, j)) {
                handler.handle(Operator.INS, t1);
                ++i;
                continue;
            }
            if (matrix.isGreaterY(i, j)) {
                handler.handle(Operator.DEL, t2);
                ++j;
                continue;
            }
            if (!matrix.isSameXY(i, j)) continue;
            if (t1.equals(t2)) {
                handler.handle(Operator.MATCH, t1);
                ++i;
                ++j;
                continue;
            }
            handler.handle(Operator.INS, t1);
            ++i;
        }
        while (i < length1) {
            handler.handle(Operator.INS, first.get(i));
            ++i;
        }
        while (j < length2) {
            handler.handle(Operator.DEL, second.get(j));
            ++j;
        }
    }
}

