/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.List;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.algorithm.DataLengthException;
import org.pageseeder.diffx.algorithm.DiffAlgorithm;
import org.pageseeder.diffx.algorithm.ElementState;
import org.pageseeder.diffx.algorithm.Matrix;
import org.pageseeder.diffx.algorithm.MatrixProcessor;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.handler.MuxHandler;
import org.pageseeder.diffx.sequence.TokenListSlicer;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.Token;

public final class MatrixXMLAlgorithm
implements DiffAlgorithm {
    public static final int DEFAULT_THRESHOLD = 64000000;
    private static final boolean DEBUG = false;
    private boolean slice = true;
    private int threshold = 64000000;

    public void setSlice(boolean slice) {
        this.slice = slice;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean isDiffComputable(List<? extends Token> first, List<? extends Token> second) {
        if (first.size() * second.size() <= this.threshold) {
            return true;
        }
        TokenListSlicer slicer = new TokenListSlicer(first, second);
        int commonCount = this.slice ? slicer.analyze() : 0;
        int matrixSize = (first.size() - commonCount) * (second.size() - commonCount);
        return matrixSize > this.threshold;
    }

    @Override
    public void diff(List<? extends Token> first, List<? extends Token> second, DiffHandler handler) {
        int lengthA = first.size();
        int lengthB = second.size();
        if (lengthA == 0 || lengthB == 0) {
            for (Token token : second) {
                handler.handle(Operator.DEL, token);
            }
            for (Token token : first) {
                handler.handle(Operator.INS, token);
            }
            return;
        }
        ElementState estate = new ElementState();
        MuxHandler muxHandler = new MuxHandler(handler, estate);
        this.diff(first, second, muxHandler, estate);
    }

    private void diff(List<? extends Token> first, List<? extends Token> second, DiffHandler handler, ElementState estate) {
        int common;
        TokenListSlicer slicer = new TokenListSlicer(first, second);
        int n = common = this.slice ? slicer.analyze() : 0;
        if (common > 0) {
            slicer.handleStart(handler);
            List<? extends Token> firstSub = slicer.getSubSequence1();
            List<? extends Token> secondSub = slicer.getSubSequence2();
            if (firstSub.isEmpty() || secondSub.isEmpty()) {
                for (Token token : secondSub) {
                    handler.handle(Operator.DEL, token);
                }
                for (Token token : firstSub) {
                    handler.handle(Operator.INS, token);
                }
            } else {
                this.processDiff(firstSub, secondSub, handler, estate);
            }
            slicer.handleEnd(handler);
        } else {
            this.processDiff(first, second, handler, estate);
        }
    }

    private void processDiff(List<? extends Token> first, List<? extends Token> second, DiffHandler handler, ElementState estate) {
        int lengthB;
        int lengthA = first.size();
        if (lengthA * (lengthB = second.size()) > this.threshold) {
            throw new DataLengthException(lengthA * lengthB, this.threshold);
        }
        MatrixProcessor builder = new MatrixProcessor();
        builder.setInverse(true);
        Matrix matrix = builder.process(first, second);
        int i = 0;
        int j = 0;
        while (i < lengthA && j < lengthB) {
            Token tokenA = first.get(i);
            Token tokenB = second.get(j);
            if (matrix.isGreaterX(i, j)) {
                if (estate.isAllowed(Operator.INS, tokenA) && !estate.hasPriorityOver(tokenB, tokenA)) {
                    handler.handle(Operator.INS, tokenA);
                    ++i;
                    continue;
                }
                if (tokenA.equals(tokenB) && estate.isAllowed(Operator.MATCH, tokenA)) {
                    handler.handle(Operator.MATCH, tokenA);
                    ++i;
                    ++j;
                    continue;
                }
                if (!estate.isAllowed(Operator.DEL, tokenB)) break;
                handler.handle(Operator.DEL, tokenB);
                ++j;
                continue;
            }
            if (matrix.isGreaterY(i, j)) {
                if (estate.isAllowed(Operator.DEL, tokenB) && !estate.hasPriorityOver(tokenA, tokenB)) {
                    handler.handle(Operator.DEL, tokenB);
                    ++j;
                    continue;
                }
                if (tokenA.equals(tokenB) && estate.isAllowed(Operator.MATCH, tokenA)) {
                    handler.handle(Operator.MATCH, tokenA);
                    ++i;
                    ++j;
                    continue;
                }
                if (!estate.isAllowed(Operator.INS, tokenA)) break;
                handler.handle(Operator.INS, tokenA);
                ++i;
                continue;
            }
            if (!matrix.isSameXY(i, j)) break;
            if (tokenA.equals(tokenB) && estate.isAllowed(Operator.MATCH, tokenA)) {
                handler.handle(Operator.MATCH, tokenA);
                ++i;
                ++j;
                continue;
            }
            if (estate.isAllowed(Operator.INS, tokenA) && (!(tokenB instanceof AttributeToken) || tokenA instanceof AttributeToken)) {
                handler.handle(Operator.INS, tokenA);
                ++i;
                continue;
            }
            if (!estate.isAllowed(Operator.DEL, tokenB) || tokenA instanceof AttributeToken && !(tokenB instanceof AttributeToken)) break;
            handler.handle(Operator.DEL, tokenB);
            ++j;
        }
        while (i < lengthA) {
            handler.handle(Operator.INS, first.get(i));
            ++i;
        }
        while (j < lengthB) {
            handler.handle(Operator.DEL, second.get(j));
            ++j;
        }
    }

    private void printLost(int i, int j, Matrix matrix, ElementState estate, List<? extends Token> first, List<? extends Token> second) {
        Token tokenA = first.get(i);
        Token tokenB = second.get(j);
        System.err.println("(!) Ambiguous choice in (" + i + "," + j + ")");
        System.err.println(" ? +" + tokenA);
        System.err.println(" ? -" + tokenB);
        System.err.println(" current=" + estate.current());
        System.err.println(" value in X+1=" + matrix.get(i + 1, j));
        System.err.println(" value in Y+1=" + matrix.get(i, j + 1));
        System.err.println(" equals=" + tokenA.equals(tokenB));
        System.err.println(" greaterX=" + matrix.isGreaterX(i, j));
        System.err.println(" greaterY=" + matrix.isGreaterY(i, j));
        System.err.println(" sameXY=" + matrix.isSameXY(i, j));
        System.err.println(" okFormat1=" + estate.isAllowed(Operator.MATCH, tokenA));
        System.err.println(" okFormat2=" + estate.isAllowed(Operator.MATCH, tokenB));
        System.err.println(" okInsert=" + estate.isAllowed(Operator.INS, tokenA));
        System.err.println(" okDelete=" + estate.isAllowed(Operator.DEL, tokenB));
    }

    public String toString() {
        return "MatrixXMLAlgorithm{slice=" + this.slice + ", threshold=" + this.threshold + '}';
    }
}

