/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.io.PrintStream;
import java.util.List;
import org.pageseeder.diffx.algorithm.InvMatrixInt;
import org.pageseeder.diffx.algorithm.InvMatrixShort;
import org.pageseeder.diffx.algorithm.Matrix;
import org.pageseeder.diffx.algorithm.MatrixInt;
import org.pageseeder.diffx.algorithm.MatrixShort;
import org.pageseeder.diffx.sequence.EventSequence;
import org.pageseeder.diffx.sequence.Sequence;
import org.pageseeder.diffx.token.Token;

public final class MatrixProcessor {
    private static final boolean DEBUG = false;
    private boolean inverse = false;

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    @Deprecated
    public Matrix process(EventSequence first, EventSequence second) {
        return this.process(first.getSequence(), second.getSequence());
    }

    public Matrix process(Sequence first, Sequence second) {
        Matrix matrix = this.inverse ? MatrixProcessor.computeInverse(first.tokens(), second.tokens()) : MatrixProcessor.compute(first.tokens(), second.tokens());
        return matrix;
    }

    public Matrix process(List<? extends Token> first, List<? extends Token> second) {
        Matrix matrix = this.inverse ? MatrixProcessor.computeInverse(first, second) : MatrixProcessor.compute(first, second);
        return matrix;
    }

    private static Matrix compute(List<? extends Token> first, List<? extends Token> second) {
        Matrix matrix = MatrixProcessor.getMatrix(first, second, false);
        int length1 = first.size();
        int length2 = second.size();
        matrix.setup(length1 + 1, length2 + 1);
        for (int i = 0; i < length1 + 1; ++i) {
            for (int j = 0; j < length2 + 1; ++j) {
                if (i == 0 || j == 0) {
                    matrix.set(i, j, 0);
                    continue;
                }
                if (first.get(i - 1).equals(second.get(j - 1))) {
                    matrix.incrementPath(i, j);
                    continue;
                }
                matrix.incrementByMaxPath(i, j);
            }
        }
        return matrix;
    }

    private static Matrix computeInverse(List<? extends Token> first, List<? extends Token> second) {
        Matrix matrix = MatrixProcessor.getMatrix(first, second, true);
        int length1 = first.size();
        int length2 = second.size();
        matrix.setup(length1 + 1, length2 + 1);
        for (int i = length1; i >= 0; --i) {
            for (int j = length2; j >= 0; --j) {
                if (i >= length1 || j >= length2) {
                    matrix.set(i, j, 0);
                    continue;
                }
                if (first.get(i).equals(second.get(j))) {
                    matrix.incrementPath(i, j);
                    continue;
                }
                matrix.incrementByMaxPath(i, j);
            }
        }
        return matrix;
    }

    private static void printDebug(List<? extends Token> first, List<? extends Token> second, Matrix matrix, PrintStream out) {
        out.print("A:");
        for (Token token : first) {
            out.print(token + "\t");
        }
        out.println();
        out.print("B:");
        for (Token token : second) {
            out.print(token + "\t");
        }
        out.println();
        out.println(matrix);
    }

    private static Matrix getMatrix(List<? extends Token> first, List<? extends Token> second, boolean inverse) {
        if (first.size() + 1 > Short.MAX_VALUE || second.size() + 1 > Short.MAX_VALUE) {
            return inverse ? new InvMatrixInt() : new MatrixInt();
        }
        return inverse ? new InvMatrixShort() : new MatrixShort();
    }
}

