/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.List;
import java.util.Objects;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.algorithm.DiffAlgorithm;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.token.Token;

public final class KumarRanganAlgorithm
implements DiffAlgorithm {
    private static final boolean DEBUG = false;

    @Override
    public void diff(List<? extends Token> first, List<? extends Token> second, DiffHandler handler) {
        Instance instance = new Instance(first, second);
        instance.process(handler);
    }

    private static void copyUpTo(int[] a, int[] b, int len) {
        System.arraycopy(a, 0, b, 0, len + 1);
    }

    private static class Instance {
        private int[] R1;
        private int[] R2;
        private int[] LL;
        private int[] LL1;
        private int[] LL2;
        private int R;
        private int S;
        private int J = 0;
        private final List<? extends Token> first;
        private final List<? extends Token> second;
        private DiffHandler handler;

        Instance(List<? extends Token> first, List<? extends Token> second) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
        }

        public void process(DiffHandler handler) {
            int m = this.first.size();
            int n = this.second.size();
            int p = this.calculateLength(m, n);
            this.handler = handler;
            this.computeLCS(0, m - 1, 0, n - 1, m, n, p);
        }

        private void init(int n) {
            this.R1 = new int[n + 1];
            this.R2 = new int[n + 1];
            this.LL = new int[n + 1];
            this.LL1 = new int[n + 1];
            this.LL2 = new int[n + 1];
            this.J = 0;
        }

        private void computeLCS(int startA, int endA, int startB, int endB, int m, int n, int p) {
            if (m - p < 2) {
                this.computeLCSBaseCase(startA, endA, startB, endB, m, n, p);
            } else {
                this.computeLCSMoreWaste(startA, endA, startB, endB, m, n, p);
            }
        }

        private void fillOne(int startA, int endA, int startB, int endB, int m, int n, int sign) {
            int i = this.S;
            int j = 1;
            boolean over = false;
            this.R2[0] = n + 1;
            while (i > 0 & !over) {
                int posB;
                int lowerB = j > this.R ? 0 : this.R1[j];
                for (posB = this.R2[j - 1] - 1; posB > lowerB && !this.first.get((i - 1) * sign + startA).equals(this.second.get((posB - 1) * sign + startB)); --posB) {
                }
                int temp = Math.max(posB, lowerB);
                if (temp == 0) {
                    over = true;
                    continue;
                }
                this.R2[j] = temp;
                --i;
                ++j;
            }
            this.R = j - 1;
        }

        private int[] calMid(int startA, int endA, int startB, int endB, int m, int n, int sign, int x) {
            this.LL = new int[n + 1];
            this.R = 0;
            this.S = m;
            while (this.S >= m - x) {
                this.fillOne(startA, endA, startB, endB, m, n, sign);
                KumarRanganAlgorithm.copyUpTo(this.R2, this.R1, this.R);
                --this.S;
            }
            KumarRanganAlgorithm.copyUpTo(this.R1, this.LL, this.R);
            return this.LL;
        }

        private void computeLCSBaseCase(int startA, int endA, int startB, int endB, int m, int n, int p) {
            this.LL = this.calMid(startA, endA, startB, endB, m, n, 1, m - p);
            this.deleteUpTo(this.LL[p] - 1 + startB);
            int i = 0;
            while (i < p && this.first.get(i + startA).equals(this.second.get(this.LL[p - i] - 1 + startB))) {
                this.handler.handle(Operator.MATCH, this.first.get(i + startA));
                ++this.J;
                if (++i >= p) continue;
                this.deleteUpTo(this.LL[p - i] - 1 + startB);
            }
            if (i < m) {
                this.handler.handle(Operator.INS, this.first.get(i + startA));
            }
            ++i;
            while (i < m) {
                this.handler.handle(Operator.MATCH, this.first.get(i + startA));
                ++this.J;
                ++i;
                while (i < m && this.J < endB && !this.first.get(i + startA).equals(this.second.get(this.J))) {
                    this.deleteUpTo(this.J + 1);
                }
            }
            this.deleteUpTo(this.LL[0] - 1 + startB);
        }

        private void computeLCSMoreWaste(int startA, int endA, int startB, int endB, int m, int n, int p) {
            int k;
            int waste1 = (int)Math.ceil((float)(m - p) / 2.0f);
            this.LL1 = this.calMid(endA, startA, endB, startB, m, n, -1, waste1);
            int r1 = this.R;
            for (int j = 0; j <= r1; ++j) {
                this.LL1[j] = n + 1 - this.LL1[j];
            }
            int waste2 = (int)Math.floor((float)(m - p) / 2.0f);
            this.LL2 = this.calMid(startA, endA, startB, endB, m, n, 1, waste2);
            int r2 = this.R;
            for (k = Math.max(r1, r2); k > 0 && (k > r1 || p - k > r2 || this.LL1[k] >= this.LL2[p - k]); --k) {
            }
            int u = k + waste1;
            int v = this.LL1[k];
            this.computeLCS(startA, startA + u - 1, startB, startB + v - 1, u - 1 + 1, v - 1 + 1, u - waste1);
            this.computeLCS(startA + u, endA, startB + v, endB, endA - startA + 1 - u, endB - startB + 1 - v, m - u - waste2);
        }

        private int calculateLength(int m, int n) {
            this.init(n);
            this.R = 0;
            this.S = m + 1;
            while (this.S > this.R) {
                --this.S;
                this.fillOne(0, m - 1, 0, n - 1, m, n, 1);
                KumarRanganAlgorithm.copyUpTo(this.R2, this.R1, this.R);
            }
            return this.S;
        }

        private void deleteUpTo(int jSeq2) {
            while (jSeq2 > this.J) {
                this.handler.handle(Operator.DEL, this.second.get(this.J++));
            }
        }

        private void printLL() {
            System.err.print(" LL={");
            for (int element : this.LL) {
                System.err.print(" " + element);
            }
            System.err.println(" }");
            System.err.print("  J={");
            for (int i = this.LL.length - 1; i >= 0; --i) {
                System.err.print(" " + (this.LL[i] - 1));
            }
            System.err.println(" }");
        }
    }
}

