/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.List;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.algorithm.DiffAlgorithm;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.token.Token;

public final class HirschbergAlgorithm
implements DiffAlgorithm {
    private static final boolean DEBUG = false;

    @Override
    public void diff(List<? extends Token> first, List<? extends Token> second, DiffHandler handler) {
        HirschbergAlgorithm.algorithmC(first.size(), second.size(), first, second, handler);
    }

    private static int[] algorithmB(int m, int n, List<? extends Token> a, List<? extends Token> b) {
        int[][] k = new int[2][n + 1];
        for (int i = 1; i <= m; ++i) {
            if (n + 1 >= 0) {
                System.arraycopy(k[1], 0, k[0], 0, n + 1);
            }
            for (int j = 1; j <= n; ++j) {
                k[1][j] = a.get(i - 1).equals(b.get(j - 1)) ? k[0][j - 1] + 1 : Math.max(k[1][j - 1], k[0][j]);
            }
        }
        return k[1];
    }

    private static int[] algorithmBRev(int m, int n, List<? extends Token> a, List<? extends Token> b) {
        int[][] k = new int[2][n + 1];
        for (int i = m - 1; i >= 0; --i) {
            if (n + 1 >= 0) {
                System.arraycopy(k[1], 0, k[0], 0, n + 1);
            }
            for (int j = n - 1; j >= 0; --j) {
                k[1][n - j] = a.get(i).equals(b.get(j)) ? k[0][n - j - 1] + 1 : Math.max(k[1][n - j - 1], k[0][n - j]);
            }
        }
        return k[1];
    }

    private static int findK(int[] l1, int[] l2, int n) {
        int m = 0;
        int k = 0;
        for (int j = 0; j <= n; ++j) {
            int s = l1[j] + l2[n - j];
            if (m >= s) continue;
            m = s;
            k = j;
        }
        return k;
    }

    private static void algorithmC(int m, int n, List<? extends Token> a, List<? extends Token> b, DiffHandler handler) {
        if (n == 0) {
            for (Token token : a) {
                handler.handle(Operator.INS, token);
            }
        } else if (m == 0) {
            for (Token token : b) {
                handler.handle(Operator.DEL, token);
            }
        } else if (m == 1) {
            boolean match = false;
            Token token = a.get(0);
            for (int j = 0; j < n; ++j) {
                if (token.equals(b.get(j)) && !match) {
                    handler.handle(Operator.MATCH, token);
                    match = true;
                    continue;
                }
                handler.handle(Operator.DEL, b.get(j));
            }
            if (!match) {
                handler.handle(Operator.INS, token);
            }
        } else {
            int h = (int)Math.floor((double)m / 2.0);
            int[] nArray = HirschbergAlgorithm.algorithmB(h, n, a.subList(0, h), b);
            int[] l2 = HirschbergAlgorithm.algorithmBRev(m - h, n, a.subList(h, a.size()), b);
            int k = HirschbergAlgorithm.findK(nArray, l2, n);
            HirschbergAlgorithm.algorithmC(h, k, a.subList(0, h), b.subList(0, k), handler);
            HirschbergAlgorithm.algorithmC(m - h, n - k, a.subList(h, a.size()), b.subList(k, b.size()), handler);
        }
    }
}

