/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.io.IOException;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.algorithm.DiffXAlgorithm;
import org.pageseeder.diffx.algorithm.ElementState;
import org.pageseeder.diffx.algorithm.Matrix;
import org.pageseeder.diffx.algorithm.MatrixProcessor;
import org.pageseeder.diffx.format.DiffXFormatter;
import org.pageseeder.diffx.sequence.EventSequence;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.Token;

public final class GuanoAlgorithm
implements DiffXAlgorithm {
    private static final boolean DEBUG = false;
    private final EventSequence sequence1;
    private final EventSequence sequence2;
    private final int length1;
    private final int length2;
    private transient Matrix matrix;
    private final transient ElementState estate = new ElementState();
    private transient int length = -1;

    public GuanoAlgorithm(EventSequence seq0, EventSequence seq1) {
        this.sequence1 = seq0;
        this.sequence2 = seq1;
        this.length1 = seq0.size();
        this.length2 = seq1.size();
        this.matrix = null;
    }

    @Override
    public int length() {
        if (this.length < 0) {
            MatrixProcessor builder = new MatrixProcessor();
            builder.setInverse(true);
            this.matrix = builder.process(this.sequence1, this.sequence2);
            this.length = this.matrix.getLCSLength();
        }
        return this.length;
    }

    @Override
    public void process(DiffXFormatter formatter) throws IOException {
        this.processEmpty(formatter);
        if (this.length1 == 0 || this.length2 == 0) {
            return;
        }
        this.length();
        int i = 0;
        int j = 0;
        while (i < this.length1 && j < this.length2) {
            Token t1 = this.sequence1.getToken(i);
            Token t2 = this.sequence2.getToken(j);
            if (this.matrix.isGreaterX(i, j)) {
                if (this.estate.isAllowed(Operator.INS, t1) && !this.estate.hasPriorityOver(t2, t1)) {
                    formatter.insert(t1);
                    this.estate.handle(Operator.INS, t1);
                    ++i;
                    continue;
                }
                if (t1.equals(t2) && this.estate.isAllowed(Operator.MATCH, t1)) {
                    formatter.format(t1);
                    this.estate.handle(Operator.MATCH, t1);
                    ++i;
                    ++j;
                    continue;
                }
                if (!this.estate.isAllowed(Operator.DEL, t2)) break;
                formatter.delete(t2);
                this.estate.handle(Operator.DEL, t2);
                ++j;
                continue;
            }
            if (this.matrix.isGreaterY(i, j)) {
                if (this.estate.isAllowed(Operator.DEL, t2) && !this.estate.hasPriorityOver(t1, t2)) {
                    formatter.delete(t2);
                    this.estate.handle(Operator.DEL, t2);
                    ++j;
                    continue;
                }
                if (t1.equals(t2) && this.estate.isAllowed(Operator.MATCH, t1)) {
                    formatter.format(t1);
                    this.estate.handle(Operator.MATCH, t1);
                    ++i;
                    ++j;
                    continue;
                }
                if (!this.estate.isAllowed(Operator.INS, t1)) break;
                formatter.insert(t1);
                this.estate.handle(Operator.INS, t1);
                ++i;
                continue;
            }
            if (!this.matrix.isSameXY(i, j)) break;
            if (t1.equals(t2) && this.estate.isAllowed(Operator.MATCH, t1)) {
                formatter.format(t1);
                this.estate.handle(Operator.MATCH, t1);
                ++i;
                ++j;
                continue;
            }
            if (this.estate.isAllowed(Operator.INS, t1) && (!(t2 instanceof AttributeToken) || t1 instanceof AttributeToken)) {
                this.estate.handle(Operator.INS, t1);
                formatter.insert(t1);
                ++i;
                continue;
            }
            if (!this.estate.isAllowed(Operator.DEL, t2) || t1 instanceof AttributeToken && !(t2 instanceof AttributeToken)) break;
            formatter.delete(t2);
            this.estate.handle(Operator.DEL, t2);
            ++j;
        }
        while (i < this.length1) {
            this.estate.handle(Operator.INS, this.sequence1.getToken(i));
            formatter.insert(this.sequence1.getToken(i));
            ++i;
        }
        while (j < this.length2) {
            this.estate.handle(Operator.DEL, this.sequence2.getToken(j));
            formatter.delete(this.sequence2.getToken(j));
            ++j;
        }
    }

    @Override
    public final EventSequence getFirstSequence() {
        return this.sequence1;
    }

    @Override
    public final EventSequence getSecondSequence() {
        return this.sequence2;
    }

    private void processEmpty(DiffXFormatter formatter) throws IOException {
        int i;
        if (this.length1 == 0) {
            for (i = 0; i < this.length2; ++i) {
                formatter.delete(this.sequence2.getToken(i));
            }
        }
        if (this.length2 == 0) {
            for (i = 0; i < this.length1; ++i) {
                formatter.insert(this.sequence1.getToken(i));
            }
        }
    }

    private void printLost(int i, int j) {
        Token t1 = this.sequence1.getToken(i);
        Token t2 = this.sequence2.getToken(j);
        System.err.println("(!) Ambiguous choice in (" + i + "," + j + ")");
        System.err.println(" ? +" + t1);
        System.err.println(" ? -" + t2);
        System.err.println(" current=" + this.estate.current());
        System.err.println(" value in X+1=" + this.matrix.get(i + 1, j));
        System.err.println(" value in Y+1=" + this.matrix.get(i, j + 1));
        System.err.println(" equals=" + t1.equals(t2));
        System.err.println(" greaterX=" + this.matrix.isGreaterX(i, j));
        System.err.println(" greaterY=" + this.matrix.isGreaterY(i, j));
        System.err.println(" sameXY=" + this.matrix.isSameXY(i, j));
        System.err.println(" okFormat1=" + this.estate.isAllowed(Operator.MATCH, t1));
        System.err.println(" okFormat2=" + this.estate.isAllowed(Operator.MATCH, t2));
        System.err.println(" okInsert=" + this.estate.isAllowed(Operator.INS, t1));
        System.err.println(" okDelete=" + this.estate.isAllowed(Operator.DEL, t2));
    }
}

