/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.io.UncheckedIOException;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.Token;

public final class ElementState
implements DiffHandler {
    private transient StartElementToken[] openElements;
    private transient Operator[] openChanges;
    private transient int size;

    public ElementState(int initialCapacity) throws IllegalArgumentException {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.openElements = new StartElementToken[initialCapacity];
        this.openChanges = new Operator[initialCapacity];
    }

    public ElementState() {
        this(12);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.openElements.length;
        if (minCapacity > oldCapacity) {
            StartElementToken[] oldElements = this.openElements;
            Operator[] oldChanges = this.openChanges;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.openElements = new StartElementToken[newCapacity];
            this.openChanges = new Operator[newCapacity];
            System.arraycopy(oldElements, 0, this.openElements, 0, this.size);
            System.arraycopy(oldChanges, 0, this.openChanges, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(StartElementToken element) {
        return this.indexOf(element) >= 0;
    }

    public int indexOf(StartElementToken element) {
        if (element == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.openElements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!element.equals(this.openElements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(StartElementToken element) {
        if (element == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.openElements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!element.equals(this.openElements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public StartElementToken current() {
        if (!this.isEmpty()) {
            return this.openElements[this.size - 1];
        }
        return null;
    }

    public Operator currentChange() {
        if (!this.isEmpty()) {
            return this.openChanges[this.size - 1];
        }
        return null;
    }

    public boolean matchCurrent(Token token) {
        if (this.isEmpty()) {
            return false;
        }
        if (!(token instanceof EndElementToken)) {
            return false;
        }
        return ((EndElementToken)token).match(this.current());
    }

    @Override
    public void handle(Operator operator, Token token) throws UncheckedIOException, IllegalStateException {
        if (token instanceof StartElementToken) {
            this.push((StartElementToken)token, operator);
        } else if (token instanceof EndElementToken) {
            this.pop();
        }
    }

    public boolean isAllowed(Operator operator, Token token) {
        if (!(token instanceof EndElementToken)) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return ((EndElementToken)token).match(this.current()) && this.openChanges[this.size - 1] == operator;
    }

    public boolean hasPriorityOver(Token token1, Token token2) {
        return token1 instanceof AttributeToken && !(token2 instanceof AttributeToken) && !this.isEmpty();
    }

    private void push(StartElementToken token, Operator operator) {
        this.ensureCapacity(this.size + 1);
        this.openElements[this.size] = token;
        this.openChanges[this.size] = operator;
        ++this.size;
    }

    public StartElementToken pop() {
        if (this.size > 0) {
            --this.size;
            return this.openElements[this.size];
        }
        return null;
    }

    public StartElementToken get(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.openElements[index];
    }

    public StartElementToken remove(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        StartElementToken oldValue = this.openElements[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.openElements, index + 1, this.openElements, index, numMoved);
        }
        this.openElements[--this.size] = null;
        return oldValue;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.openElements[i] = null;
        }
        this.size = 0;
    }

    private void checkRange(int index) throws IndexOutOfBoundsException {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }
}

