/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.action;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.sequence.Sequence;
import org.pageseeder.diffx.token.Token;

public final class Operations {
    private Operations() {
    }

    public static List<Token> generate(List<Operation> operations, boolean positive) {
        LinkedList<Token> generated = new LinkedList<Token>();
        for (Operation operation : operations) {
            if (positive ? operation.operator() == Operator.INS : operation.operator() == Operator.DEL) {
                generated.add(operation.token());
                continue;
            }
            if (operation.operator() != Operator.MATCH) continue;
            generated.add(operation.token());
        }
        return generated;
    }

    public static List<Operation> flip(List<Operation> operations) {
        ArrayList<Operation> reverse = new ArrayList<Operation>(operations.size());
        for (Operation operation : operations) {
            reverse.add(operation.flip());
        }
        return reverse;
    }

    public static Sequence apply(Sequence input, List<Operation> operations) {
        List<Token> tokens = Operations.apply(input.tokens(), operations);
        Sequence out = new Sequence(tokens.size());
        out.addTokens(tokens);
        return out;
    }

    public static List<Token> apply(List<Token> input, List<Operation> operations) {
        ArrayList<Token> out = new ArrayList<Token>(input.size());
        int i = 0;
        try {
            for (Operation operation : operations) {
                switch (operation.operator()) {
                    case MATCH: {
                        out.add(input.get(i));
                        ++i;
                        break;
                    }
                    case INS: {
                        out.add(operation.token());
                        break;
                    }
                    case DEL: {
                        ++i;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Actions cannot be applied to specified input", ex);
        }
        if (i != input.size()) {
            throw new IllegalArgumentException("Actions do not match specified input");
        }
        return out;
    }

    public static void handle(List<Operation> operations, DiffHandler handler) {
        for (Operation operation : operations) {
            handler.handle(operation.operator(), operation.token());
        }
    }
}

