/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.action;

import java.util.List;
import org.pageseeder.diffx.action.Action;
import org.pageseeder.diffx.action.Actions;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.sequence.Sequence;
import org.pageseeder.diffx.token.Token;

public final class DiffResult {
    private final List<Action> actions;

    public DiffResult(List<Action> actions) {
        this.actions = actions;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public DiffResult reverse() {
        return new DiffResult(Actions.reverse(this.actions));
    }

    public boolean isApplicableTo(List<Token> to, List<Token> from) {
        return Actions.isApplicable(to, from, this.actions);
    }

    public List<Token> apply(List<Token> tokens) {
        return Actions.apply(tokens, this.actions);
    }

    public Sequence apply(Sequence sequence) {
        return Actions.apply(sequence, this.actions);
    }

    public boolean hasChanges() {
        return this.actions.stream().anyMatch(action -> action.operator() != Operator.MATCH);
    }

    public boolean isIdentical() {
        return this.actions.stream().noneMatch(action -> action.operator() != Operator.MATCH);
    }

    public int countEvents(Operator operator) {
        return this.actions.stream().filter(action -> action.operator() == operator).mapToInt(action -> action.tokens().size()).sum();
    }
}

