/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.pageseeder.diffx.action.Action;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.format.DiffXFormatter;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.sequence.Sequence;
import org.pageseeder.diffx.token.Token;

public class Actions {
    public static List<Token> generate(List<Action> actions, boolean positive) {
        ArrayList<Token> generated = new ArrayList<Token>();
        for (Action action : actions) {
            if (positive ? action.operator() == Operator.INS : action.operator() == Operator.DEL) {
                generated.addAll(action.tokens());
                continue;
            }
            if (action.operator() != Operator.MATCH) continue;
            generated.addAll(action.tokens());
        }
        return generated;
    }

    public static List<Operation> toOperations(List<Action> actions) {
        LinkedList<Operation> operations = new LinkedList<Operation>();
        for (Action action : actions) {
            Operator operator = action.operator();
            for (Token token : action.tokens()) {
                operations.add(new Operation(operator, token));
            }
        }
        return operations;
    }

    public static List<Action> reverse(List<Action> actions) {
        ArrayList<Action> reverse = new ArrayList<Action>(actions.size());
        for (Action action : actions) {
            reverse.add(action.flip());
        }
        return reverse;
    }

    public static Sequence apply(Sequence input, List<Action> actions) {
        List<Token> tokens = Actions.apply(input.tokens(), actions);
        Sequence out = new Sequence(tokens.size());
        tokens.forEach(out::addToken);
        return out;
    }

    public static List<Token> apply(List<? extends Token> input, List<Action> actions) {
        ArrayList<Token> out = new ArrayList<Token>(input.size());
        int i = 0;
        try {
            for (Action action : actions) {
                int count = action.tokens().size();
                switch (action.operator()) {
                    case MATCH: {
                        out.addAll(input.subList(i, i + count));
                        i += count;
                        break;
                    }
                    case INS: {
                        out.addAll(action.tokens());
                        break;
                    }
                    case DEL: {
                        i += count;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Actions cannot be applied to specified input", ex);
        }
        if (i != input.size()) {
            throw new IllegalArgumentException("Actions do not match specified input");
        }
        return out;
    }

    public static boolean isApplicable(List<? extends Token> a, List<? extends Token> b, List<Action> actions) {
        int i = 0;
        int j = 0;
        for (Action action : actions) {
            if (action.operator() == Operator.MATCH) {
                for (Token token : action.tokens()) {
                    if (i >= a.size() || !token.equals(a.get(i))) {
                        return false;
                    }
                    if (j >= b.size() || !token.equals(b.get(j))) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
                continue;
            }
            if (action.operator() == Operator.INS) {
                for (Token token : action.tokens()) {
                    if (i >= a.size() || !token.equals(a.get(i))) {
                        return false;
                    }
                    ++i;
                }
                continue;
            }
            if (action.operator() != Operator.DEL) continue;
            for (Token token : action.tokens()) {
                if (j >= b.size() || !token.equals(b.get(j))) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    public static void format(List<Action> actions, DiffXFormatter formatter) throws IOException {
        block5: for (Action action : actions) {
            switch (action.operator()) {
                case MATCH: {
                    for (Token token : action.tokens()) {
                        formatter.format(token);
                    }
                    continue block5;
                }
                case INS: {
                    for (Token token : action.tokens()) {
                        formatter.insert(token);
                    }
                    continue block5;
                }
                case DEL: {
                    for (Token token : action.tokens()) {
                        formatter.delete(token);
                    }
                    continue block5;
                }
            }
        }
    }

    public static void handle(List<Action> actions, DiffHandler handler) {
        for (Action action : actions) {
            for (Token token : action.tokens()) {
                handler.handle(action.operator(), token);
            }
        }
    }

    public static void applyTo(List<Action> actions, DiffHandler handler) {
        handler.start();
        for (Action action : actions) {
            for (Token token : action.tokens()) {
                handler.handle(action.operator(), token);
            }
        }
        handler.end();
    }
}

