/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.action;

import java.util.ArrayList;
import java.util.List;
import org.pageseeder.diffx.action.Operator;
import org.pageseeder.diffx.token.Token;

public final class Action {
    private final Operator operator;
    private final List<Token> tokens;

    public Action(Operator operator) {
        this(operator, new ArrayList<Token>());
    }

    public Action(Operator operator, List<Token> tokens) {
        if (operator == null) {
            throw new NullPointerException("An action must have a type.");
        }
        this.operator = operator;
        this.tokens = tokens;
    }

    public void add(Token token) {
        this.tokens.add(token);
    }

    public List<Token> tokens() {
        return this.tokens;
    }

    public Operator operator() {
        return this.operator;
    }

    public Action flip() {
        switch (this.operator) {
            case DEL: {
                return new Action(Operator.INS, this.tokens);
            }
            case INS: {
                return new Action(Operator.DEL, this.tokens);
            }
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        if (this.operator != action.operator) {
            return false;
        }
        return this.tokens.equals(action.tokens);
    }

    public int hashCode() {
        int result = this.operator.hashCode();
        result = 31 * result + this.tokens.hashCode();
        return result;
    }

    public String toString() {
        return "Action{" + (Object)((Object)this.operator) + "," + this.tokens + '}';
    }
}

