/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.pageseeder.diffx.DiffXException;
import org.pageseeder.diffx.config.DiffXConfig;
import org.pageseeder.diffx.config.TextGranularity;
import org.pageseeder.diffx.config.WhiteSpaceProcessing;
import org.pageseeder.diffx.core.DefaultXMLProcessor;
import org.pageseeder.diffx.core.DiffProcessor;
import org.pageseeder.diffx.core.OptimisticXMLProcessor;
import org.pageseeder.diffx.core.TextOnlyProcessor;
import org.pageseeder.diffx.format.CompleteXMLDiffOutput;
import org.pageseeder.diffx.format.DefaultXMLDiffOutput;
import org.pageseeder.diffx.format.StrictXMLDiffOutput;
import org.pageseeder.diffx.format.XMLDiffOutput;
import org.pageseeder.diffx.format.XMLDiffReporter;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.load.DOMLoader;
import org.pageseeder.diffx.load.LineLoader;
import org.pageseeder.diffx.load.Loader;
import org.pageseeder.diffx.load.SAXLoader;
import org.pageseeder.diffx.load.XMLEventLoader;
import org.pageseeder.diffx.load.XMLStreamLoader;
import org.pageseeder.diffx.sequence.Sequence;
import org.pageseeder.diffx.util.CommandLine;
import org.pageseeder.diffx.xml.NamespaceSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class Main {
    private Main() {
    }

    public static boolean equivalent(File xml1, File xml2) throws DiffXException, IOException {
        SAXLoader loader = new SAXLoader();
        Sequence seq0 = loader.load(xml1);
        Sequence seq1 = loader.load(xml2);
        return seq0.equals(seq1);
    }

    public static boolean equivalent(InputStream xml1, InputStream xml2) throws DiffXException, IOException {
        SAXLoader loader = new SAXLoader();
        Sequence seq0 = loader.load(new InputSource(xml1));
        Sequence seq1 = loader.load(new InputSource(xml2));
        return seq0.equals(seq1);
    }

    public static boolean equivalent(Reader xml1, Reader xml2) throws DiffXException, IOException {
        SAXLoader loader = new SAXLoader();
        Sequence seq0 = loader.load(new InputSource(xml1));
        Sequence seq1 = loader.load(new InputSource(xml2));
        return seq0.equals(seq1);
    }

    public static void diff(Node xml1, Node xml2, Writer out, DiffXConfig config) throws DiffXException, IOException {
        DOMLoader loader = new DOMLoader();
        if (config != null) {
            loader.setConfig(config.toDiffConfig());
        }
        Sequence seq1 = loader.load(xml1);
        Sequence seq2 = loader.load(xml2);
        Main.diff(seq1, seq2, out);
    }

    public static void diff(NodeList xml1, NodeList xml2, Writer out, DiffXConfig config) throws DiffXException, IOException {
        DOMLoader loader = new DOMLoader();
        if (config != null) {
            loader.setConfig(config.toDiffConfig());
        }
        Sequence seq1 = loader.load(xml1);
        Sequence seq2 = loader.load(xml2);
        Main.diff(seq1, seq2, out);
    }

    public static void diff(Reader xml1, Reader xml2, Writer out, DiffXConfig config) throws DiffXException, IOException {
        SAXLoader loader = new SAXLoader();
        if (config != null) {
            loader.setConfig(config.toDiffConfig());
        }
        Sequence seq1 = loader.load(new InputSource(xml1));
        Sequence seq2 = loader.load(new InputSource(xml2));
        Main.diff(seq1, seq2, out);
    }

    public static void diff(Reader xml1, Reader xml2, Writer out) throws DiffXException, IOException {
        SAXLoader loader = new SAXLoader();
        Sequence seq1 = loader.load(new InputSource(xml1));
        Sequence seq2 = loader.load(new InputSource(xml2));
        Main.diff(seq1, seq2, out);
    }

    public static void diff(InputStream xml1, InputStream xml2, OutputStream out) throws DiffXException, IOException {
        SAXLoader loader = new SAXLoader();
        Sequence seq1 = loader.load(new InputSource(xml1));
        Sequence seq2 = loader.load(new InputSource(xml2));
        Main.diff(seq1, seq2, (Writer)new OutputStreamWriter(out));
    }

    private static void diff(Sequence seq1, Sequence seq2, Writer out) {
        DefaultXMLDiffOutput output = new DefaultXMLDiffOutput(out);
        NamespaceSet namespaces = NamespaceSet.merge(seq1.getNamespaces(), seq2.getNamespaces());
        output.setNamespaces(namespaces);
        DefaultXMLProcessor processor = new DefaultXMLProcessor();
        processor.diff(seq1.tokens(), seq2.tokens(), output);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            Main.usage();
            return;
        }
        try {
            DiffProcessor processor;
            OutputStreamWriter out;
            DiffHandler output;
            boolean profile = CommandLine.hasSwitch("-profile", args);
            boolean quiet = CommandLine.hasSwitch("-quiet", args);
            File xml1 = new File(args[args.length - 2]);
            File xml2 = new File(args[args.length - 1]);
            long t0 = System.currentTimeMillis();
            Loader loader = Main.getRecorder(args);
            if (loader == null) {
                return;
            }
            Sequence seq1 = loader.load(xml1);
            Sequence seq2 = loader.load(xml2);
            long t1 = System.currentTimeMillis();
            if (profile) {
                System.err.println("Loaded files in " + (t1 - t0) + "ms");
            }
            DiffXConfig config = new DiffXConfig();
            config.setGranularity(Main.getTextGranularity(args));
            config.setWhiteSpaceProcessing(Main.getWhiteSpaceProcessing(args));
            if (!quiet) {
                System.err.println("Whitespace processing: " + (Object)((Object)Main.getTextGranularity(args)) + " " + (Object)((Object)Main.getWhiteSpaceProcessing(args)));
            }
            if ((output = Main.getOutputFormat(args, out = new OutputStreamWriter(Main.getOutput(args), StandardCharsets.UTF_8))) == null) {
                return;
            }
            if (output instanceof XMLDiffOutput) {
                NamespaceSet namespaces = NamespaceSet.merge(seq1.getNamespaces(), seq2.getNamespaces());
                ((XMLDiffOutput)output).setNamespaces(namespaces);
            }
            if (!quiet) {
                System.err.println("Matrix: " + seq1.size() + "x" + seq2.size());
            }
            if ((processor = Main.getProcessor(args)) == null) {
                return;
            }
            processor.diff(seq1.tokens(), seq2.tokens(), output);
            long t2 = System.currentTimeMillis();
            if (profile) {
                System.err.println("Executed algorithm files in " + (t2 - t1) + "ms");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void usage() {
        System.err.println("Compare the SAX events returned by two XML files.");
        System.err.println("usage:");
        System.err.println("  Main [options] xml_file1 xml_file2");
        System.err.println("where:");
        System.err.println("  xml_file1 = Path to the new XML file");
        System.err.println("  xml_file2 = Path to the old XML file");
        System.err.println("options:");
        System.err.println("  -profile        Display profiling info");
        System.err.println("  -o [output]     The output file");
        System.err.println("  -l [loader]     Choose a specific loader");
        System.err.println("                   sax* | dom | stream | stax | text");
        System.err.println("  -p [processor]  Choose a specific algorithm");
        System.err.println("                   optimistic* | xml | text");
        System.err.println("  -f [format]     Choose a specific formatter");
        System.err.println("                   default* | complete | strict | report");
        System.err.println("  -w [whitespace] Define whitespace processing");
        System.err.println("                   preserve* | compare | ignore");
        System.err.println("  -g [granul]     Define text diffing granularity");
        System.err.println("                   word* | text | character");
        System.err.println(" * indicates option used by default.");
        System.exit(1);
    }

    private static Loader getRecorder(String[] args) {
        String loaderArg = CommandLine.getParameter("-l", args);
        if (loaderArg == null || "sax".equals(loaderArg)) {
            return new SAXLoader();
        }
        if ("dom".equals(loaderArg)) {
            return new DOMLoader();
        }
        if ("text".equals(loaderArg)) {
            return new LineLoader();
        }
        if ("stream".equals(loaderArg)) {
            return new XMLStreamLoader();
        }
        if ("stax".equals(loaderArg)) {
            return new XMLEventLoader();
        }
        Main.usage();
        return null;
    }

    private static OutputStream getOutput(String[] args) throws FileNotFoundException {
        String outArg = CommandLine.getParameter("-o", args);
        if (outArg == null) {
            return System.out;
        }
        return new BufferedOutputStream(new FileOutputStream(outArg));
    }

    private static DiffProcessor getProcessor(String[] args) {
        String loaderArg = CommandLine.getParameter("-p", args);
        if (loaderArg == null || "optimistic".equals(loaderArg)) {
            return new DefaultXMLProcessor();
        }
        if ("xml".equals(loaderArg)) {
            return new OptimisticXMLProcessor();
        }
        if ("text".equals(loaderArg)) {
            return new TextOnlyProcessor();
        }
        Main.usage();
        return null;
    }

    private static DiffHandler getOutputFormat(String[] args, Writer out) {
        String formatArg = CommandLine.getParameter("-f", args);
        if (formatArg == null || "default".equals(formatArg)) {
            return new DefaultXMLDiffOutput(out);
        }
        if ("complete".equals(formatArg)) {
            return new CompleteXMLDiffOutput(out);
        }
        if ("strict".equals(formatArg)) {
            return new StrictXMLDiffOutput(out);
        }
        if ("report".equals(formatArg)) {
            return new XMLDiffReporter(out);
        }
        Main.usage();
        return null;
    }

    private static WhiteSpaceProcessing getWhiteSpaceProcessing(String[] args) {
        String formatArg = CommandLine.getParameter("-w", args);
        if (formatArg == null || "preserve".equals(formatArg)) {
            return WhiteSpaceProcessing.PRESERVE;
        }
        if ("compare".equals(formatArg)) {
            return WhiteSpaceProcessing.COMPARE;
        }
        if ("ignore".equals(formatArg)) {
            return WhiteSpaceProcessing.IGNORE;
        }
        Main.usage();
        return null;
    }

    private static TextGranularity getTextGranularity(String[] args) {
        String formatArg = CommandLine.getParameter("-g", args);
        if (formatArg == null || "word".equals(formatArg)) {
            return TextGranularity.SPACE_WORD;
        }
        if ("text".equals(formatArg)) {
            return TextGranularity.TEXT;
        }
        if ("character".equals(formatArg)) {
            return TextGranularity.CHARACTER;
        }
        Main.usage();
        return null;
    }
}

